/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.login;

import cn.bctools.auth.component.SmsEmailComponent;
import cn.bctools.auth.entity.User;
import cn.bctools.auth.login.LoginHandler;
import cn.bctools.auth.login.dto.PhoneDto;
import cn.bctools.auth.service.UserExtensionService;
import cn.bctools.auth.service.UserService;
import cn.bctools.common.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="phone")
public class PhoneLoginHandler
implements LoginHandler<PhoneDto> {
    private static final Logger log = LoggerFactory.getLogger(PhoneLoginHandler.class);
    UserExtensionService userExtensionService;
    SmsEmailComponent smsComponent;
    UserService userService;

    @Override
    public User handle(String code, String appId, PhoneDto phoneDto) {
        this.smsComponent.check(phoneDto.getPhone(), phoneDto.getCode(), () -> new BusinessException("\u9a8c\u8bc1\u5931\u8d25"));
        User user = this.userService.phone(phoneDto.getPhone());
        return user;
    }

    @Override
    public void bind(User user, String code, String appId) {
    }

    public PhoneLoginHandler(UserExtensionService userExtensionService, SmsEmailComponent smsComponent, UserService userService) {
        this.userExtensionService = userExtensionService;
        this.smsComponent = smsComponent;
        this.userService = userService;
    }
}

