/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.login;

import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserTenant;
import cn.bctools.auth.login.LoginHandler;
import cn.bctools.auth.login.dto.InviteDto;
import cn.bctools.auth.service.RoleService;
import cn.bctools.auth.service.UserRoleService;
import cn.bctools.auth.service.UserService;
import cn.bctools.auth.service.UserTenantService;
import cn.bctools.common.entity.dto.UserDto;
import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.TenantContextHolder;
import cn.bctools.redis.utils.RedisUtils;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="invite")
public class InviteLoginHandler
implements LoginHandler<InviteDto> {
    private static final Logger log = LoggerFactory.getLogger(InviteLoginHandler.class);
    RedisUtils redisUtils;
    UserService userService;
    RoleService roleService;
    UserRoleService userRoleService;
    UserTenantService userTenantService;

    @Override
    public User handle(String code, String appId, InviteDto inviteDto) {
        TenantContextHolder.setTenantId((String)inviteDto.getId());
        User one = (User)this.userService.getOne((Wrapper)Wrappers.query((Object)new User().setPhone(inviteDto.getPhone())));
        if (ObjectUtil.isNotEmpty((Object)one)) {
            UserTenant tenantUser = (UserTenant)this.userTenantService.getOne((Wrapper)Wrappers.query((Object)new UserTenant().setUserId(one.getId()).setTenantId(inviteDto.getId())));
            if (ObjectUtil.isNotEmpty((Object)tenantUser)) {
                if (tenantUser.getCancelFlag().booleanValue()) {
                    throw new BusinessException("\u60a8\u5df2\u88ab\u516c\u53f8\u7981\u7528");
                }
                return one;
            }
            UserTenant userTenant = new UserTenant().setRealName(inviteDto.getRealName()).setUserId(one.getId());
            this.userTenantService.save(userTenant);
            return one;
        }
        User user = new User().setPhone(inviteDto.getPhone()).setRealName(inviteDto.getRealName());
        user.setCancelFlag(false);
        UserTenant userTenant = new UserTenant().setRealName(inviteDto.getRealName());
        UserDto o = (UserDto)this.redisUtils.get(inviteDto.getInvite());
        user.setInvite(o.getId());
        this.userService.saveUser(user, userTenant);
        this.userRoleService.grandDefaultSysRole(user.getId());
        log.info("\u9080\u8bf7\u65b0\u7528\u6237\u52a0\u5165:{}  \u9080\u8bf7 {} \u52a0\u5165\u56e2\u961f", (Object)o.getRealName(), (Object)user.getRealName());
        return user;
    }

    @Override
    public void bind(User user, String code, String appId) {
    }

    public InviteLoginHandler(RedisUtils redisUtils, UserService userService, RoleService roleService, UserRoleService userRoleService, UserTenantService userTenantService) {
        this.redisUtils = redisUtils;
        this.userService = userService;
        this.roleService = roleService;
        this.userRoleService = userRoleService;
        this.userTenantService = userTenantService;
    }
}

