/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.config;

import cn.bctools.common.entity.dto.UserInfoDto;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;
import org.springframework.stereotype.Component;

@Component
public class TokenStoreConfig {
    private static final Logger log = LoggerFactory.getLogger(TokenStoreConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    TokenStore tokenStore(RedisConnectionFactory factory) {
        RedisTokenStore tokenStore = new RedisTokenStore(factory);
        tokenStore.setAuthenticationKeyGenerator((AuthenticationKeyGenerator)new DefaultAuthenticationKeyGenerator(){
            private static final String CLIENT_ID = "client_id";
            private static final String SCOPE = "scope";
            private static final String USERNAME = "username";
            private static final String USERAGENT = "userAgent";
            private static final String IP = "IP";

            public String extractKey(OAuth2Authentication authentication) {
                LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                OAuth2Request authorizationRequest = authentication.getOAuth2Request();
                if (!authentication.isClientOnly()) {
                    values.put(USERNAME, authentication.getName());
                }
                values.put(CLIENT_ID, authorizationRequest.getClientId());
                if (authorizationRequest.getScope() != null) {
                    values.put(SCOPE, OAuth2Utils.formatParameterList(new TreeSet(authorizationRequest.getScope())));
                }
                UserInfoDto principal = (UserInfoDto)authentication.getPrincipal();
                values.put(USERAGENT, principal.getUserDto().getUserAgent());
                values.put(IP, principal.getUserDto().getIp());
                return this.generateKey(values);
            }
        });
        tokenStore.setPrefix("jvsauth:");
        return tokenStore;
    }
}

