/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.component;

import cn.bctools.auth.api.enums.SysRoleEnum;
import cn.bctools.auth.entity.Permission;
import cn.bctools.auth.entity.Role;
import cn.bctools.auth.entity.TenantPo;
import cn.bctools.auth.entity.User;
import cn.bctools.auth.entity.UserRole;
import cn.bctools.auth.entity.UserTenant;
import cn.bctools.auth.entity.enums.RoleTypeEnum;
import cn.bctools.auth.service.DataRoleService;
import cn.bctools.auth.service.DeptService;
import cn.bctools.auth.service.JobService;
import cn.bctools.auth.service.PermissionService;
import cn.bctools.auth.service.RoleService;
import cn.bctools.auth.service.TenantService;
import cn.bctools.auth.service.UserRoleService;
import cn.bctools.auth.service.UserService;
import cn.bctools.auth.service.UserTenantService;
import cn.bctools.common.entity.dto.DataScopeDto;
import cn.bctools.common.entity.dto.UserDto;
import cn.bctools.common.entity.dto.UserInfoDto;
import cn.bctools.common.exception.BusinessException;
import cn.bctools.common.utils.BeanCopyUtil;
import cn.bctools.common.utils.ObjectNull;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserInfoComponent {
    private static final Logger log = LoggerFactory.getLogger(UserInfoComponent.class);
    DeptService deptService;
    JobService jobService;
    UserRoleService userRoleService;
    RoleService roleService;
    PermissionService permissionService;
    UserService userService;
    DataRoleService dataRoleService;
    TenantService tenantService;
    UserTenantService userTenantService;

    public UserInfoDto<UserDto> getUserInfoDto(String userId, Boolean adminFlag, String tenantId) {
        List<String> roleIds;
        if (adminFlag.booleanValue()) {
            userId = tenantId;
        }
        if ((roleIds = this.userRoleService.list((Wrapper)Wrappers.lambdaQuery().eq(UserRole::getUserId, (Object)userId)).stream().map(UserRole::getRoleId).collect(Collectors.toList())).isEmpty()) {
            return new UserInfoDto();
        }
        Role designRole = (Role)this.roleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Role::getType, (Object)RoleTypeEnum.userRole)).eq(Role::getRoleName, (Object)SysRoleEnum.APP_ADMIN.getName())).in(Role::getId, roleIds));
        List permission = this.permissionService.queryUserPermission(roleIds).stream().map(Permission::getPermission).collect(Collectors.toList());
        List<DataScopeDto> dataScopeList = this.dataRoleService.queryUserPermission(roleIds);
        return new UserInfoDto().setPermissions(permission).setDataScope(dataScopeList).setRoles(roleIds);
    }

    public UserDto getUserInfoDto(User info, String tenantId) {
        if (ObjectUtil.isEmpty((Object)info)) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        UserTenant tenantServiceOne = (UserTenant)this.userTenantService.getOne((Wrapper)Wrappers.query((Object)new UserTenant().setTenantId(tenantId).setUserId(info.getId())));
        UserDto userDto = (UserDto)BeanCopyUtil.copy(UserDto.class, (Object[])new Object[]{info, tenantServiceOne});
        userDto.setId(info.getId());
        TenantPo thisTenantPo = (TenantPo)this.tenantService.getById((Serializable)((Object)tenantId));
        if (ObjectNull.isNotNull((Object[])new Object[]{thisTenantPo})) {
            userDto.setAdminFlag(Boolean.valueOf(thisTenantPo.getAdminUserId().equals(info.getId())));
        } else {
            userDto.setAdminFlag(Boolean.valueOf(false));
        }
        return userDto;
    }

    public UserInfoComponent(DeptService deptService, JobService jobService, UserRoleService userRoleService, RoleService roleService, PermissionService permissionService, UserService userService, DataRoleService dataRoleService, TenantService tenantService, UserTenantService userTenantService) {
        this.deptService = deptService;
        this.jobService = jobService;
        this.userRoleService = userRoleService;
        this.roleService = roleService;
        this.permissionService = permissionService;
        this.userService = userService;
        this.dataRoleService = dataRoleService;
        this.tenantService = tenantService;
        this.userTenantService = userTenantService;
    }
}

