/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.component;

import cn.bctools.auth.component.cons.SaveUserDto;
import cn.bctools.auth.entity.TenantPo;
import cn.bctools.auth.entity.User;
import cn.bctools.common.entity.dto.UserDto;
import cn.bctools.common.exception.BusinessException;
import cn.bctools.email.EmailUtils;
import cn.bctools.redis.utils.RedisUtils;
import cn.bctools.sms.config.AliSmsConfig;
import cn.bctools.sms.utils.SmsSendUtils;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jolokia.util.Base64Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SmsEmailComponent {
    private static final Logger log = LoggerFactory.getLogger(SmsEmailComponent.class);
    RedisUtils redisUtils;
    AliSmsConfig aliSmsConfig;
    EmailUtils emailUtils;

    public String type() {
        return this.aliSmsConfig.getTemplate().getLogin();
    }

    public void check(String phone, String code, Supplier<BusinessException> exceptionHandler) {
        boolean exists = this.redisUtils.exists("sms:" + this.type() + ":" + phone + ":" + code);
        if (!exists) {
            throw exceptionHandler.get();
        }
    }

    public void sendPhoneCode(String phone) {
        HashMap<String, String> mappings = new HashMap<String, String>(2);
        String code = SmsSendUtils.smsCode();
        int expireMinutes = 5;
        mappings.put("code", code);
        mappings.put("expireMinutes", String.valueOf(expireMinutes));
        SmsSendUtils.aliImpl((String)this.type(), Collections.singletonList(phone), mappings);
        String key = "sms:" + this.type() + ":" + phone + ":" + code;
        this.redisUtils.setExpire(key, (Object)code, 5L, TimeUnit.MINUTES);
        log.info("\u53d1\u9001\u77ed\u4fe1\u6d88\u606f\uff0c\u624b\u673a\u53f7\u4e3a:{},\u9a8c\u8bc1\u7801\u4e3a:{}", (Object)JSONObject.toJSONString((Object)phone), (Object)code);
    }

    @Async
    public void sendUserInvite(UserDto currentUser, User toUser, TenantPo tenantPo) {
        try {
            String title = String.format("\u3010JVS\u5feb\u901f\u5f00\u53d1\u5e73\u53f0\u56e2\u961f\u3011\u5c0a\u656c\u7684%s(\u5148\u751f/\u5973\u58eb). %s\u9080\u8bf7\u60a8\u7684\u52a0\u5165%s\u521d\u521b\u56e2\u961f\u3002\u671f\u5f85\u60a8\u7684\u52a0\u5165", toUser.getRealName(), currentUser.getRealName(), tenantPo.getName());
            SaveUserDto saveUserDto = new SaveUserDto().setUser(toUser.getRealName()).setDate(DateUtil.formatDate((Date)new Date())).setContent("\u3000<h1>%s</h1>  <br/>\u3000\u6b22\u8fce\u4f60\u4eec\u52a0\u5165\u6211\u4eec\u7684\u516c\u53f8\uff0c\u4ece\u8fd9\u4e00\u523b\u8d77\uff0c\u4f60\u5c31\u662f\u8fd9\u4e2a\u5927\u5bb6\u5ead\u91cc\u7684\u4e00\u4efd\u5b50\uff0c\u4f60\u4eec\u7684\u52aa\u529b\u662f\u6211\u4eec\u7684\u9a84\u50b2\uff0c\u6211\u4eec\u7684\u5149\u5f69\u7531\u4f60\u4eec\u6765\u70b9\u4eae\uff0c\u6211\u4eec\u8363\u8fb1\u4e0e\u5171\uff0c\u5171\u540c\u8de8\u8d8a\uff1b\u6211\u4eec\u643a\u624b\u540c\u884c\uff0c\u5171\u521b\u4f73\u7ee9\u3002\u5728\u8fd9\u91cc\uff0c\u6ca1\u6709\u9886\u5bfc\u4e0e\u4e0b\u7ea7\uff0c\u6ca1\u6709\u5265\u524a\u4e0e\u538b\u8feb\u3002\u6709\u7684\u53ea\u662f\u670b\u53cb\u59d0\u59b9\u4e0e\u5144\u5f1f\u3002\u4f60\u4eec\u7684\u52aa\u529b\u6211\u4eec\u8bb0\u5728\u5fc3\u5e95\uff0c\u6211\u4eec\u7684\u8fc7\u9519\u8bf7\u60a8\u6307\u70b9\u3002\u5e0c\u671b\u6211\u4eec\u5171\u540c\u6325\u6d12\u6c57\u6c34\uff0c\u521b\u9020\u81ea\u5df1\u7684\u65b0\u7bc7\u7ae0\u3002").setImg(tenantPo.getLogo()).setTenant(tenantPo.getName()).setTitle(tenantPo.getName());
            Map data = BeanUtil.beanToMap((Object)saveUserDto);
            String html = StrUtil.format((CharSequence)this.readHtml(), (Map)data);
            String email = toUser.getEmail();
            this.emailUtils.sendEmailMessage(title, html, Collections.singletonList(email));
        }
        catch (Exception e) {
            log.error("\u90ae\u7bb1\u53d1\u9001\u5f02\u5e38:", (Throwable)e);
        }
    }

    public String readHtml() {
        ClassPathResource classPathResource = new ClassPathResource("static/email.saveuser.html");
        byte[] bytes = IoUtil.readBytes((InputStream)classPathResource.getStream());
        String s = new String(bytes);
        return s;
    }

    public void sendEmailCode(UserDto currentUser, String email, TenantPo tenantPo) {
        try {
            String idStr = SmsSendUtils.smsCode();
            this.redisUtils.setExpire("emailcode:" + email, (Object)idStr, 5L, TimeUnit.MINUTES);
            String title = String.format("\u3010JVS\u5feb\u901f\u5f00\u53d1\u5e73\u53f0\u56e2\u961f\u3011\u7ed1\u5b9a\u90ae\u7bb1\u9a8c\u8bc1\u7801\u4e3a%s", idStr);
            SaveUserDto saveUserDto = new SaveUserDto().setUser(currentUser.getRealName()).setDate(DateUtil.formatDateTime((Date)new Date())).setContent(String.format("\u3000<h1>%s</h1>  <br/>\u3000\u6b22\u8fce\u4f60\u4eec\u52a0\u5165\u6211\u4eec\u7684\u516c\u53f8\uff0c\u4ece\u8fd9\u4e00\u523b\u8d77\uff0c\u4f60\u5c31\u662f\u8fd9\u4e2a\u5927\u5bb6\u5ead\u91cc\u7684\u4e00\u4efd\u5b50\uff0c\u4f60\u4eec\u7684\u52aa\u529b\u662f\u6211\u4eec\u7684\u9a84\u50b2\uff0c\u6211\u4eec\u7684\u5149\u5f69\u7531\u4f60\u4eec\u6765\u70b9\u4eae\uff0c\u6211\u4eec\u8363\u8fb1\u4e0e\u5171\uff0c\u5171\u540c\u8de8\u8d8a\uff1b\u6211\u4eec\u643a\u624b\u540c\u884c\uff0c\u5171\u521b\u4f73\u7ee9\u3002\u5728\u8fd9\u91cc\uff0c\u6ca1\u6709\u9886\u5bfc\u4e0e\u4e0b\u7ea7\uff0c\u6ca1\u6709\u5265\u524a\u4e0e\u538b\u8feb\u3002\u6709\u7684\u53ea\u662f\u670b\u53cb\u59d0\u59b9\u4e0e\u5144\u5f1f\u3002\u4f60\u4eec\u7684\u52aa\u529b\u6211\u4eec\u8bb0\u5728\u5fc3\u5e95\uff0c\u6211\u4eec\u7684\u8fc7\u9519\u8bf7\u60a8\u6307\u70b9\u3002\u5e0c\u671b\u6211\u4eec\u5171\u540c\u6325\u6d12\u6c57\u6c34\uff0c\u521b\u9020\u81ea\u5df1\u7684\u65b0\u7bc7\u7ae0\u3002", idStr)).setImg(tenantPo.getLogo()).setTenant(tenantPo.getName()).setTitle(tenantPo.getName());
            Map data = BeanUtil.beanToMap((Object)saveUserDto);
            String encode = "data:image/png;base64," + Base64Util.encode((byte[])HttpUtil.downloadBytes((String)tenantPo.getLogo()));
            data.put("img", encode);
            String html = StrUtil.format((CharSequence)this.readHtml(), (Map)data);
            this.emailUtils.sendEmailMessage(title, html, Collections.singletonList(email));
        }
        catch (Exception e) {
            log.error("\u90ae\u7bb1\u53d1\u9001\u5f02\u5e38:", (Throwable)e);
        }
    }

    public void checkEmailCode(String email, String code, Supplier<BusinessException> supplier) {
        Object exists = this.redisUtils.get("emailcode:" + email);
        if (ObjectUtil.isEmpty((Object)exists) || !exists.equals(code)) {
            throw supplier.get();
        }
    }

    public SmsEmailComponent(RedisUtils redisUtils, AliSmsConfig aliSmsConfig, EmailUtils emailUtils) {
        this.redisUtils = redisUtils;
        this.aliSmsConfig = aliSmsConfig;
        this.emailUtils = emailUtils;
    }
}

