/*
 * Decompiled with CFR 0.152.
 */
package cn.bctools.auth.comparator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UriPatternComparator
implements Comparator<String> {
    @Override
    public int compare(String thisPattern, String otherPattern) {
        List<String> otherPatternList;
        List<String> thisPatternList = this.simplify(thisPattern);
        if (thisPatternList.equals(otherPatternList = this.simplify(otherPattern))) {
            return 0;
        }
        int min = Math.min(thisPatternList.size(), otherPatternList.size());
        for (int i = 0; i < min; ++i) {
            int otherValue;
            int thisValue = PatternEnum.getValue(thisPatternList.get(i));
            if (thisValue == (otherValue = PatternEnum.getValue(otherPatternList.get(i)))) continue;
            return thisValue - otherValue;
        }
        if (thisPatternList.size() == otherPatternList.size()) {
            return 0;
        }
        if (thisPatternList.size() < otherPatternList.size()) {
            return PatternEnum.DOUBLE_WILDCARD.value == PatternEnum.getValue(otherPatternList.get(min)) ? 1 : -1;
        }
        return PatternEnum.DOUBLE_WILDCARD.value == PatternEnum.getValue(thisPatternList.get(min)) ? -1 : 1;
    }

    private List<String> simplify(String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return Collections.emptyList();
        }
        String[] split = pattern.split("\\?")[0].split("/");
        ArrayList<String> result = new ArrayList<String>();
        boolean exist = false;
        for (String str : split) {
            int value = PatternEnum.getValue(str);
            if (PatternEnum.DOUBLE_WILDCARD.value == value) {
                if (!exist) {
                    result.add(str);
                }
                exist = true;
                continue;
            }
            result.add(str);
            exist = false;
        }
        return result;
    }

    private static enum PatternEnum {
        DOUBLE_WILDCARD("**", 0),
        SINGLE_WILDCARD("*", 1);

        private final String str;
        private final int value;

        public static int getValue(String str) {
            for (PatternEnum value : PatternEnum.values()) {
                if (!value.str.equals(str)) continue;
                return value.value;
            }
            return 2;
        }

        public String getStr() {
            return this.str;
        }

        public int getValue() {
            return this.value;
        }

        private PatternEnum(String str, int value) {
            this.str = str;
            this.value = value;
        }
    }
}

