/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.web.utils;

import cn.bbwres.biscuit.entity.UserBaseInfo;
import cn.bbwres.biscuit.utils.JsonUtil;
import cn.bbwres.biscuit.web.BiscuitWebProperties;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebFrameworkUtils {
    private BiscuitWebProperties biscuitWebProperties;
    private static WebFrameworkUtils webFrameworkUtils;
    private static final String CLIENT_IP_HTTP_KEY = "X-Real-IP";

    @Autowired
    public void setBiscuitWebProperties(BiscuitWebProperties biscuitWebProperties) {
        this.biscuitWebProperties = biscuitWebProperties;
    }

    @PostConstruct
    public void initialize() {
        webFrameworkUtils = this;
        WebFrameworkUtils.webFrameworkUtils.biscuitWebProperties = this.biscuitWebProperties;
    }

    public static UserBaseInfo<?> getRequestUser() {
        String userInfoHeaderName = WebFrameworkUtils.webFrameworkUtils.biscuitWebProperties.getUserInfoHeaderName();
        String userInfoStr = WebFrameworkUtils.getHeader(userInfoHeaderName);
        return (UserBaseInfo)JsonUtil.toObjectByBase64Json((String)userInfoStr, UserBaseInfo.class);
    }

    public static UserBaseInfo<?> getRequestUser(boolean checkNull) {
        UserBaseInfo<?> userBaseInfo = WebFrameworkUtils.getRequestUser();
        if (checkNull) {
            Assert.notNull(userBaseInfo, (String)"user not null");
        }
        return userBaseInfo;
    }

    public static String getClientIp() {
        return WebFrameworkUtils.getHeader(CLIENT_IP_HTTP_KEY);
    }

    public static String getHeader(String name) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(servletRequestAttributes)) {
            return null;
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        return request.getHeader(name);
    }
}

