/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.web.swagger;

import cn.bbwres.biscuit.web.swagger.EnumPropertyCustomizer;
import cn.bbwres.biscuit.web.swagger.SwaggerProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.SecurityService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springdoc.core.providers.JavadocProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={OpenAPI.class})
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(prefix="springdoc.api-docs", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerAutoConfiguration {
    @Bean
    public OpenAPI openApi(SwaggerProperties properties) {
        Map<String, SecurityScheme> securitySchemas = this.buildSecuritySchemes();
        OpenAPI openApi = new OpenAPI().info(this.buildInfo(properties)).components(new Components().securitySchemes(securitySchemas));
        securitySchemas.keySet().forEach(key -> openApi.addSecurityItem(new SecurityRequirement().addList(key)));
        return openApi;
    }

    private Info buildInfo(SwaggerProperties properties) {
        return new Info().title(properties.getTitle()).description(properties.getDescription()).version(properties.getVersion()).contact(new Contact().name(properties.getAuthor()));
    }

    private Map<String, SecurityScheme> buildSecuritySchemes() {
        HashMap<String, SecurityScheme> securitySchemes = new HashMap<String, SecurityScheme>();
        SecurityScheme securityScheme = new SecurityScheme().type(SecurityScheme.Type.OAUTH2).name("Authorization").in(SecurityScheme.In.HEADER);
        securitySchemes.put("Authorization", securityScheme);
        return securitySchemes;
    }

    @Bean
    public OpenAPIService openApiBuilder(Optional<OpenAPI> openAPI, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomizers, Optional<List<ServerBaseUrlCustomizer>> serverBaseUrlCustomizers, Optional<JavadocProvider> javadocProvider) {
        return new OpenAPIService(openAPI, securityParser, springDocConfigProperties, propertyResolverUtils, openApiBuilderCustomizers, serverBaseUrlCustomizers, javadocProvider);
    }

    @Bean
    public EnumPropertyCustomizer enumPropertyCustomizer() {
        return new EnumPropertyCustomizer();
    }
}

