/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.web.handler;

import cn.bbwres.biscuit.dto.Result;
import cn.bbwres.biscuit.exception.SystemRuntimeException;
import cn.bbwres.biscuit.exception.constants.GlobalErrorCodeConstants;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerMethodExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class BiscuitHandlerExceptionResolver
extends AbstractHandlerMethodExceptionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BiscuitHandlerExceptionResolver.class);
    protected MessageSourceAccessor messages;
    private final ObjectMapper objectMapper;

    public BiscuitHandlerExceptionResolver(ObjectMapper objectMapper, ObjectProvider<MessageSourceAccessor> messagesProvider) {
        this.messages = (MessageSourceAccessor)messagesProvider.getIfAvailable();
        this.objectMapper = objectMapper;
    }

    protected ModelAndView doResolveHandlerMethodException(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, Exception ex) {
        LOG.warn("request:[{}],exception:[{}]", new Object[]{request.getRequestURI(), ex.getMessage(), ex});
        String message = ObjectUtils.isEmpty((Object)ex.getMessage()) ? GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getMessage() : ex.getMessage();
        String errorCode = GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode();
        if (ex instanceof SystemRuntimeException) {
            SystemRuntimeException systemRuntimeException = (SystemRuntimeException)ex;
            errorCode = systemRuntimeException.getErrorCode();
            return this.resultModelAndView(errorCode, message);
        }
        if (ex instanceof MissingServletRequestParameterException || ex instanceof IllegalArgumentException || ex instanceof MethodArgumentTypeMismatchException || ex instanceof BindException || ex instanceof ValidationException) {
            errorCode = GlobalErrorCodeConstants.BAD_REQUEST.getCode();
            return this.resultModelAndView(errorCode, message);
        }
        if (ex instanceof NoHandlerFoundException) {
            errorCode = GlobalErrorCodeConstants.NOT_FOUND.getCode();
            return this.resultModelAndView(errorCode, message);
        }
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            errorCode = GlobalErrorCodeConstants.METHOD_NOT_ALLOWED.getCode();
            return this.resultModelAndView(errorCode, message);
        }
        return this.resultModelAndView(errorCode, message);
    }

    private ModelAndView resultModelAndView(String errorCode, String message) {
        if (!ObjectUtils.isEmpty((Object)this.messages)) {
            message = this.messages.getMessage(message, null, message);
        }
        ModelAndView modelAndView = new ModelAndView((View)new MappingJackson2JsonView(this.objectMapper));
        Result result = new Result(errorCode, message);
        modelAndView.addObject((Object)result);
        return modelAndView;
    }
}

