/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.web.swagger;

import cn.bbwres.biscuit.enums.BaseEnum;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class EnumPropertyCustomizer
implements PropertyCustomizer {
    public Schema<?> customize(Schema property, AnnotatedType type) {
        SimpleType fieldType;
        Class fieldClazz;
        if (type.getType() instanceof SimpleType && BaseEnum.class.isAssignableFrom(fieldClazz = (fieldType = (SimpleType)type.getType()).getRawClass()) && fieldClazz.getGenericInterfaces()[0] instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldClazz.getGenericInterfaces()[0];
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            Schema<?> schema = this.getSchemaByType(actualTypeArgument, property);
            String description = this.getDescription(fieldClazz);
            if (ObjectUtils.isEmpty((Object)property.getTitle())) {
                schema.setTitle(description);
            } else {
                schema.setTitle(property.getTitle() + ":" + description);
            }
            if (ObjectUtils.isEmpty((Object)property.getDescription())) {
                schema.setDescription(description);
            } else {
                schema.setDescription(property.getDescription() + ":" + description);
            }
            return schema;
        }
        return property;
    }

    private String getDescription(Class<?> fieldClazz) {
        BaseEnum[] values = (BaseEnum[])fieldClazz.getEnumConstants();
        List displayValues = Arrays.stream(values).map(codedEnum -> {
            if (codedEnum instanceof Enum) {
                return ((Enum)codedEnum).name() + " - " + codedEnum.getDisplayName();
            }
            return codedEnum.getValue() + " - " + codedEnum.getDisplayName();
        }).collect(Collectors.toList());
        StringBuilder str = new StringBuilder();
        if (!CollectionUtils.isEmpty(displayValues)) {
            str.append((String)displayValues.get(0));
            for (int i = 1; i < displayValues.size(); ++i) {
                str.append(",").append((String)displayValues.get(i));
            }
        }
        return str.toString();
    }

    private Schema<?> getSchemaByType(Type type, Schema<?> sourceSchema) {
        PrimitiveType item = PrimitiveType.fromType((Type)type);
        Object schema = item == null ? new ObjectSchema() : item.createProperty();
        String schemaType = schema.getType();
        String format = schema.getFormat();
        BeanUtils.copyProperties(sourceSchema, (Object)schema);
        return schema.type(schemaType).format(format);
    }
}

