/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.service.redis;

import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import cn.bbwres.biscuit.security.oauth2.service.redis.pojo.OAuth2AllTokenKey;
import cn.bbwres.biscuit.security.oauth2.service.redis.pojo.OAuth2AuthorizationTokenKeyInfo;
import cn.bbwres.biscuit.security.oauth2.service.redis.pojo.OAuth2ClientPrincipalName;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;

public class RedisOAuth2AuthorizationService
implements OAuth2AuthorizationService {
    private final RegisteredClientRepository registeredClientRepository;
    private final RedisOperations<Object, Object> redisOperations;
    private final BiscuitSecurityProperties biscuitSecurityProperties;

    public RedisOAuth2AuthorizationService(RegisteredClientRepository registeredClientRepository, RedisOperations<Object, Object> redisOperations, BiscuitSecurityProperties biscuitSecurityProperties) {
        this.biscuitSecurityProperties = biscuitSecurityProperties;
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull(redisOperations, (String)"authorizationGrantAuthorizationRepository cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.redisOperations = redisOperations;
    }

    public void save(final OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        final Instant now = Instant.now();
        final long offsetSecond = this.biscuitSecurityProperties.getTokenExpireOffsetSecond();
        final OAuth2AllTokenKey oauth2AllTokenKey = new OAuth2AllTokenKey();
        oauth2AllTokenKey.setId(authorization.getId());
        final OAuth2ClientPrincipalName oauth2ClientPrincipalName = new OAuth2ClientPrincipalName().setRegisteredClientId(authorization.getRegisteredClientId()).setPrincipalName(authorization.getPrincipalName());
        this.checkAndDeleteOtherToken(authorization.getRegisteredClientId(), oauth2ClientPrincipalName.getRedisKey());
        final List<OAuth2AuthorizationTokenKeyInfo> oauth2AuthorizationTokens = this.buildTokenInfo(authorization);
        SessionCallback<Void> sessionCallback = new SessionCallback<Void>(this){

            @org.springframework.lang.Nullable
            public Void execute(RedisOperations operations) throws DataAccessException {
                long maxTimeToLive = -1L;
                HashSet<String> tokenKeys = new HashSet<String>(16);
                for (OAuth2AuthorizationTokenKeyInfo oauth2AuthorizationToken : oauth2AuthorizationTokens) {
                    String redisKey = oauth2AuthorizationToken.getRedisKey();
                    tokenKeys.add(redisKey);
                    long timeToLive = oauth2AuthorizationToken.getExpiresAt().getEpochSecond() - now.getEpochSecond() + offsetSecond;
                    if (maxTimeToLive < timeToLive) {
                        maxTimeToLive = timeToLive;
                    }
                    operations.opsForValue().set((Object)redisKey, (Object)authorization, timeToLive, TimeUnit.SECONDS);
                }
                String allTokenKey = oauth2AllTokenKey.getRedisKey();
                operations.opsForList().rightPushAll((Object)allTokenKey, tokenKeys.toArray());
                operations.expire((Object)allTokenKey, maxTimeToLive, TimeUnit.SECONDS);
                String oauth2ClientPrincipalNameKey = oauth2ClientPrincipalName.getRedisKey();
                operations.opsForList().rightPush((Object)oauth2ClientPrincipalNameKey, (Object)allTokenKey);
                operations.expire((Object)oauth2ClientPrincipalNameKey, maxTimeToLive, TimeUnit.SECONDS);
                return null;
            }
        };
        this.redisOperations.executePipelined((SessionCallback)sessionCallback);
    }

    private void checkAndDeleteOtherToken(String registeredClientId, String registeredClientIdPrincipalNameKey) {
        RegisteredClient registeredClient = this.buildRegisteredClient(registeredClientId);
        Boolean singleUserLogin = (Boolean)registeredClient.getClientSettings().getSetting("client.single_user_login");
        if (singleUserLogin != null && singleUserLogin.booleanValue()) {
            this.deleteByRegisteredClientIdPrincipalNameKey(registeredClientIdPrincipalNameKey);
        }
    }

    private void deleteByRegisteredClientIdPrincipalNameKey(String registeredClientIdPrincipalNameKey) {
        Object tokenId = this.redisOperations.opsForList().leftPop((Object)registeredClientIdPrincipalNameKey);
        if (Objects.isNull(tokenId)) {
            return;
        }
        this.deleteTokenByTokenId(tokenId);
        this.deleteByRegisteredClientIdPrincipalNameKey(registeredClientIdPrincipalNameKey);
    }

    private void deleteTokenByTokenId(Object tokenId) {
        HashSet<Object> tokenKeys = new HashSet<Object>(16);
        tokenKeys.addAll(this.redisOperations.opsForList().range(tokenId, 0L, -1L));
        tokenKeys.add(tokenId);
        this.redisOperations.delete(tokenKeys);
    }

    public void remove(OAuth2Authorization authorization) {
        Assert.notNull((Object)authorization, (String)"authorization cannot be null");
        ArrayList<String> keys = new ArrayList<String>(16);
        String authorizationKeyId = String.format("oauth2_authorization_all:%s", authorization.getId());
        keys.add(authorizationKeyId);
        OAuth2ClientPrincipalName oauth2ClientPrincipalName = new OAuth2ClientPrincipalName().setRegisteredClientId(authorization.getRegisteredClientId()).setPrincipalName(authorization.getPrincipalName());
        List<OAuth2AuthorizationTokenKeyInfo> oauth2AuthorizationTokens = this.buildTokenInfo(authorization);
        for (OAuth2AuthorizationTokenKeyInfo oauth2AuthorizationToken : oauth2AuthorizationTokens) {
            keys.add(oauth2AuthorizationToken.getRedisKey());
        }
        this.redisOperations.delete(keys);
        this.redisOperations.opsForList().remove((Object)oauth2ClientPrincipalName, 1L, (Object)authorizationKeyId);
    }

    @Nullable
    public OAuth2Authorization findById(String id) {
        Assert.hasText((String)id, (String)"id cannot be empty");
        String authorizationKeyId = String.format("oauth2_authorization_all:%s", id);
        HashSet tokenKeys = new HashSet(16);
        tokenKeys.addAll(this.redisOperations.opsForList().range((Object)authorizationKeyId, 0L, -1L));
        for (Object tokenKey : tokenKeys) {
            Object result = this.redisOperations.opsForValue().get(tokenKey);
            if (!Objects.nonNull(result)) continue;
            return (OAuth2Authorization)result;
        }
        return null;
    }

    @Nullable
    public OAuth2Authorization findByToken(String token, OAuth2TokenType tokenType) {
        Assert.hasText((String)token, (String)"token cannot be empty");
        if (tokenType != null) {
            return this.findByToken(token, tokenType.getValue());
        }
        ArrayList<String> tokenTypes = new ArrayList<String>(16);
        tokenTypes.add("code");
        tokenTypes.add("access_token");
        tokenTypes.add("refresh_token");
        tokenTypes.add("oidc_token");
        tokenTypes.add("user_code");
        tokenTypes.add("device_code");
        for (String type : tokenTypes) {
            OAuth2Authorization authorization = this.findByToken(token, type);
            if (!Objects.nonNull(authorization)) continue;
            return authorization;
        }
        return null;
    }

    private OAuth2Authorization findByToken(String token, String tokenType) {
        String redisKey = String.format("oauth2_authorization:%s:%s", tokenType, token);
        Object result = this.redisOperations.opsForValue().get((Object)redisKey);
        return Objects.isNull(result) ? null : (OAuth2Authorization)result;
    }

    private OAuth2AuthorizationTokenKeyInfo buildTokenValue(OAuth2Authorization.Token<? extends OAuth2Token> token, String tokenType) {
        OAuth2AuthorizationTokenKeyInfo authorizationToken = new OAuth2AuthorizationTokenKeyInfo();
        OAuth2Token oauth2Token = token.getToken();
        authorizationToken.setTokenValue(oauth2Token.getTokenValue());
        authorizationToken.setIssuedAt(oauth2Token.getIssuedAt());
        authorizationToken.setExpiresAt(oauth2Token.getExpiresAt());
        authorizationToken.setTokenType(tokenType);
        return authorizationToken;
    }

    private RegisteredClient buildRegisteredClient(String registeredClientId) {
        return this.registeredClientRepository.findById(registeredClientId);
    }

    private List<OAuth2AuthorizationTokenKeyInfo> buildTokenInfo(OAuth2Authorization authorization) {
        OAuth2Authorization.Token refreshToken;
        OAuth2Authorization.Token accessToken;
        OAuth2Authorization.Token oidcIdToken;
        OAuth2Authorization.Token deviceCode;
        OAuth2Authorization.Token userCode;
        ArrayList<OAuth2AuthorizationTokenKeyInfo> oauth2AuthorizationTokens = new ArrayList<OAuth2AuthorizationTokenKeyInfo>(16);
        OAuth2Authorization.Token authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
        if (authorizationCode != null) {
            oauth2AuthorizationTokens.add(this.buildTokenValue((OAuth2Authorization.Token<? extends OAuth2Token>)authorizationCode, "code"));
        }
        if ((userCode = authorization.getToken(OAuth2UserCode.class)) != null) {
            oauth2AuthorizationTokens.add(this.buildTokenValue((OAuth2Authorization.Token<? extends OAuth2Token>)userCode, "user_code"));
        }
        if ((deviceCode = authorization.getToken(OAuth2DeviceCode.class)) != null) {
            oauth2AuthorizationTokens.add(this.buildTokenValue((OAuth2Authorization.Token<? extends OAuth2Token>)deviceCode, "device_code"));
        }
        if ((oidcIdToken = authorization.getToken(OidcIdToken.class)) != null) {
            oauth2AuthorizationTokens.add(this.buildTokenValue((OAuth2Authorization.Token<? extends OAuth2Token>)oidcIdToken, "oidc_token"));
        }
        if ((accessToken = authorization.getToken(OAuth2AccessToken.class)) != null) {
            oauth2AuthorizationTokens.add(this.buildTokenValue((OAuth2Authorization.Token<? extends OAuth2Token>)accessToken, "access_token"));
        }
        if ((refreshToken = authorization.getToken(OAuth2RefreshToken.class)) != null) {
            oauth2AuthorizationTokens.add(this.buildTokenValue((OAuth2Authorization.Token<? extends OAuth2Token>)refreshToken, "refresh_token"));
        }
        return oauth2AuthorizationTokens;
    }
}

