/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.endpoint;

import cn.bbwres.biscuit.dto.Result;
import cn.bbwres.biscuit.entity.UserBaseInfo;
import cn.bbwres.biscuit.exception.constants.ErrorCode;
import cn.bbwres.biscuit.exception.constants.GlobalErrorCodeConstants;
import cn.bbwres.biscuit.security.oauth2.endpoint.ResourceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class UserInfoEndpoint {
    private final OAuth2AuthorizationService oauth2AuthorizationService;
    private final ResourceService resourceService;

    public UserInfoEndpoint(OAuth2AuthorizationService oauth2AuthorizationService, ResourceService resourceService) {
        this.oauth2AuthorizationService = oauth2AuthorizationService;
        this.resourceService = resourceService;
    }

    @PostMapping(value={"/check_token"})
    public Result<UserBaseInfo> checkToken(@RequestBody String token) {
        OAuth2Authorization oauth2Authorization = this.oauth2AuthorizationService.findByToken(token, OAuth2TokenType.ACCESS_TOKEN);
        if (ObjectUtils.isEmpty((Object)oauth2Authorization)) {
            return Result.error((ErrorCode)GlobalErrorCodeConstants.INVALID_TOKEN);
        }
        UserBaseInfo userBaseInfo = new UserBaseInfo();
        userBaseInfo.setClientId(oauth2Authorization.getRegisteredClientId());
        userBaseInfo.setUsername(oauth2Authorization.getPrincipalName());
        OAuth2Authorization.Token accessToken = oauth2Authorization.getAccessToken();
        Map claims = accessToken.getClaims();
        if (CollectionUtils.isEmpty((Map)claims)) {
            userBaseInfo.setAuthorities(new ArrayList(oauth2Authorization.getAuthorizedScopes()));
            return Result.success((Object)userBaseInfo);
        }
        userBaseInfo.setUserId(Objects.nonNull(claims.get("custom_user_id")) ? claims.get("custom_user_id").toString() : null);
        userBaseInfo.setTenantId(Objects.nonNull(claims.get("custom_tenant_id")) ? claims.get("custom_tenant_id").toString() : null);
        userBaseInfo.setUserInfo((Object)claims);
        userBaseInfo.setZhName(Objects.nonNull(claims.get("custom_zh_name")) ? claims.get("custom_zh_name").toString() : null);
        Object roles = claims.get("custom_roles");
        if (Objects.nonNull(roles)) {
            Set roles1 = (Set)roles;
            userBaseInfo.setAuthorities(new ArrayList(roles1));
        }
        return Result.success((Object)userBaseInfo);
    }

    @GetMapping(value={"/login_auth_resource"})
    public Result<List<String>> loginAuthResource() {
        return Result.success(this.resourceService.getLoginAuthResource());
    }

    @PostMapping(value={"/resource_by_role"})
    public Result<List<String>> resourceByRole(@RequestBody Set<String> rules) {
        return Result.success(this.resourceService.getResourceByRole(rules));
    }
}

