/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.config;

import cn.bbwres.biscuit.exception.SystemRuntimeException;
import cn.bbwres.biscuit.security.oauth2.constants.Oauth2ErrorCodeConstants;
import cn.bbwres.biscuit.security.oauth2.endpoint.ResourceService;
import cn.bbwres.biscuit.security.oauth2.endpoint.UserInfoEndpoint;
import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import cn.bbwres.biscuit.security.oauth2.vo.AuthUser;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.converter.RsaKeyConverters;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.OAuth2AuthorizationServerConfiguration;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsSet;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.ObjectUtils;

@AutoConfiguration
public class TokenConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenConfig.class);

    @Bean
    public UserInfoEndpoint userInfoEndpoint(OAuth2AuthorizationService oauth2AuthorizationService, ResourceService resourceService) {
        return new UserInfoEndpoint(oauth2AuthorizationService, resourceService);
    }

    @Bean
    public DelegatingOAuth2TokenGenerator oauth2TokenGenerator(ObjectProvider<OAuth2TokenCustomizer<OAuth2TokenClaimsContext>> accessTokenCustomizer, ObjectProvider<OAuth2TokenCustomizer<JwtEncodingContext>> jwtCustomizer, JWKSource<SecurityContext> jwkSource) {
        OAuth2AccessTokenGenerator oAuth2AccessTokenGenerator = new OAuth2AccessTokenGenerator();
        OAuth2TokenCustomizer oauth2TokenClaimsContextCustomizer = (OAuth2TokenCustomizer)accessTokenCustomizer.getIfAvailable();
        if (!ObjectUtils.isEmpty((Object)oauth2TokenClaimsContextCustomizer)) {
            oAuth2AccessTokenGenerator.setAccessTokenCustomizer(oauth2TokenClaimsContextCustomizer);
        }
        JwtGenerator jwtGenerator = new JwtGenerator((JwtEncoder)new NimbusJwtEncoder(jwkSource));
        OAuth2TokenCustomizer jwtEncodingContextCustomizer = (OAuth2TokenCustomizer)jwtCustomizer.getIfAvailable();
        if (!ObjectUtils.isEmpty((Object)jwtEncodingContextCustomizer)) {
            jwtGenerator.setJwtCustomizer(jwtEncodingContextCustomizer);
        }
        return new DelegatingOAuth2TokenGenerator(new OAuth2TokenGenerator[]{oAuth2AccessTokenGenerator, new OAuth2RefreshTokenGenerator(), jwtGenerator});
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2TokenCustomizer<OAuth2TokenClaimsContext> accessTokenCustomizer() {
        return context -> {
            if (context.getTokenType().equals((Object)OAuth2TokenType.ACCESS_TOKEN)) {
                OAuth2TokenClaimsSet.Builder claims = context.getClaims();
                claims.claims(claimsMap -> claimsMap.putAll(this.buildClaimsMap(context)));
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2TokenCustomizer<JwtEncodingContext> jwtEncodingContext() {
        return context -> {
            if (context.getTokenType().equals((Object)OAuth2TokenType.ACCESS_TOKEN)) {
                JwtClaimsSet.Builder claims = context.getClaims();
                claims.claims(claimsMap -> claimsMap.putAll(this.buildClaimsMap(context)));
            }
        };
    }

    private Map<String, Object> buildClaimsMap(OAuth2TokenContext context) {
        HashMap<String, Object> claims = new HashMap<String, Object>(16);
        Authentication principal = context.getPrincipal();
        Object object = principal.getPrincipal();
        if (object instanceof AuthUser) {
            AuthUser user = (AuthUser)((Object)object);
            claims.put("custom_zh_name", user.getZhName());
            claims.put("custom_user_id", user.getUserId());
            claims.put("custom_tenant_id", user.getTenantId());
        }
        Set roles = AuthorityUtils.authorityListToSet((Collection)context.getPrincipal().getAuthorities()).stream().map(c -> c.replaceFirst("^ROLE_", "")).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        claims.put("custom_roles", roles);
        claims.put("custom_grant_type", context.getAuthorizationGrantType().getValue());
        return claims;
    }

    @Bean
    public JwtDecoder jwtDecoder(JWKSource<SecurityContext> jwkSource) {
        return OAuth2AuthorizationServerConfiguration.jwtDecoder(jwkSource);
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource(BiscuitSecurityProperties properties) {
        KeyPair keyPair = this.generateRsaKey(properties);
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAKey rsaKey = new RSAKey.Builder(publicKey).privateKey(privateKey).keyID(UUID.randomUUID().toString()).build();
        JWKSet jwkSet = new JWKSet((JWK)rsaKey);
        return new ImmutableJWKSet(jwkSet);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private KeyPair generateRsaKey(BiscuitSecurityProperties properties) {
        KeyPair keyPair;
        if (!properties.getAutoGeneratorJwtKey().booleanValue()) {
            log.info("\u4f7f\u7528\u914d\u7f6e\u7684jwt\u5bc6\u94a5\u4fe1\u606f");
            if (ObjectUtils.isEmpty((Object)properties.getJwtPrivateKey()) || ObjectUtils.isEmpty((Object)properties.getJwtPublicKey())) {
                log.warn("\u5f53\u524d\u4f7f\u7528\u914d\u7f6e\u7684jwt\u5bc6\u94a5\u65f6\u5904\u7406\u5931\u8d25\uff01\u672a\u8bbe\u7f6e\u79c1\u94a5\u6216\u8005\u516c\u94a5");
                throw new SystemRuntimeException(Oauth2ErrorCodeConstants.OAUTH2_SYSTEM_CONFIG_ERROR);
            }
            try (ByteArrayInputStream publicKeyStream = new ByteArrayInputStream(properties.getJwtPublicKey().getBytes(StandardCharsets.UTF_8));){
                KeyPair keyPair2;
                try (ByteArrayInputStream privateKeyStream = new ByteArrayInputStream(properties.getJwtPrivateKey().getBytes(StandardCharsets.UTF_8));){
                    RSAPublicKey publicKey = (RSAPublicKey)RsaKeyConverters.x509().convert((Object)publicKeyStream);
                    RSAPrivateKey privateKey = (RSAPrivateKey)RsaKeyConverters.pkcs8().convert((Object)privateKeyStream);
                    keyPair2 = new KeyPair(publicKey, privateKey);
                }
                return keyPair2;
            }
            catch (IOException e) {
                throw new SystemRuntimeException(Oauth2ErrorCodeConstants.OAUTH2_SYSTEM_CONFIG_ERROR);
            }
        }
        try {
            log.info("\u4f7f\u7528\u81ea\u52a8\u751f\u6210\u7684jwt\u5bc6\u94a5\u4fe1\u606f");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(properties.getAutoGeneratorJwtKeySize());
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return keyPair;
    }
}

