/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.config;

import cn.bbwres.biscuit.i18n.I18nProperties;
import cn.bbwres.biscuit.i18n.support.SystemMessageSource;
import cn.bbwres.biscuit.security.oauth2.event.AuthenticationLoginEventListener;
import cn.bbwres.biscuit.security.oauth2.event.AuthenticationLoginService;
import cn.bbwres.biscuit.security.oauth2.event.DefaultAuthenticationLoginServiceImpl;
import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@AutoConfiguration
@EnableWebSecurity
@EnableConfigurationProperties(value={BiscuitSecurityProperties.class})
public class BiscuitSecurityConfig {
    @Bean(value={"securityMessageBasename"})
    public SystemMessageSource systemMessageSource(I18nProperties i18nProperties) {
        return new SystemMessageSource(i18nProperties.getMessageSourceCacheSeconds().intValue(), i18nProperties.getSecurityMessageBasename());
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationLoginService authenticationLoginService() {
        return new DefaultAuthenticationLoginServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationLoginEventListener authenticationLoginEventListener(AuthenticationLoginService authenticationLoginService) {
        return new AuthenticationLoginEventListener(authenticationLoginService);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }
}

