/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.web;

import cn.bbwres.biscuit.dto.Result;
import cn.bbwres.biscuit.exception.SystemRuntimeException;
import cn.bbwres.biscuit.security.oauth2.constants.Oauth2ErrorCodeConstants;
import cn.bbwres.biscuit.utils.JsonUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class CustomLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomLoginUrlAuthenticationEntryPoint.class);
    private final AuthorizationServerSettings authorizationServerSettings;
    private final MessageSourceAccessor messages;

    public CustomLoginUrlAuthenticationEntryPoint(String loginFormUrl, AuthorizationServerSettings authorizationServerSettings, ObjectProvider<MessageSourceAccessor> messageSourceAccessorObjectProvider) {
        super(loginFormUrl);
        this.authorizationServerSettings = authorizationServerSettings;
        this.messages = (MessageSourceAccessor)messageSourceAccessorObjectProvider.getIfAvailable();
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (!request.getRequestURI().equals(this.authorizationServerSettings.getAuthorizationEndpoint())) {
            Result<Void> error = this.oauth2AuthenticationException(authException);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonUtil.toJson(error));
            return;
        }
        super.commence(request, response, authException);
    }

    private Result<Void> oauth2AuthenticationException(AuthenticationException authenticationException) {
        if (authenticationException instanceof BadCredentialsException || authenticationException instanceof UsernameNotFoundException) {
            return new Result(this.messages, Oauth2ErrorCodeConstants.OAUTH2_USERNAME_PASSWORD_ERROR);
        }
        if (authenticationException instanceof LockedException) {
            return new Result(this.messages, Oauth2ErrorCodeConstants.OAUTH2_USER_LOCKED);
        }
        if (authenticationException instanceof DisabledException) {
            return new Result(this.messages, Oauth2ErrorCodeConstants.OAUTH2_USER_DISABLE);
        }
        if (authenticationException instanceof AccountExpiredException || authenticationException instanceof CredentialsExpiredException) {
            return new Result(this.messages, Oauth2ErrorCodeConstants.OAUTH2_USER_EXPIRED);
        }
        Throwable cause = authenticationException.getCause();
        if (cause instanceof SystemRuntimeException) {
            SystemRuntimeException systemRuntimeException = (SystemRuntimeException)cause;
            return new Result(systemRuntimeException.getErrorCode(), systemRuntimeException.getMessage());
        }
        return new Result(this.messages, Oauth2ErrorCodeConstants.OAUTH2_ERROR);
    }
}

