/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.service.redis;

import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisOAuth2AuthorizationConsentService
implements OAuth2AuthorizationConsentService {
    private final RedisOperations<Object, Object> redisOperations;
    private final BiscuitSecurityProperties biscuitSecurityProperties;

    public RedisOAuth2AuthorizationConsentService(RedisOperations<Object, Object> redisOperations, BiscuitSecurityProperties biscuitSecurityProperties) {
        this.redisOperations = redisOperations;
        this.biscuitSecurityProperties = biscuitSecurityProperties;
    }

    public void save(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        this.redisOperations.opsForValue().set((Object)RedisOAuth2AuthorizationConsentService.buildKey(authorizationConsent), (Object)authorizationConsent, this.biscuitSecurityProperties.getAuthorizationConsentExpireSecond(), TimeUnit.SECONDS);
    }

    public void remove(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        this.redisOperations.delete((Object)RedisOAuth2AuthorizationConsentService.buildKey(authorizationConsent));
    }

    public OAuth2AuthorizationConsent findById(String registeredClientId, String principalName) {
        Assert.hasText((String)registeredClientId, (String)"registeredClientId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        Object result = this.redisOperations.opsForValue().get((Object)RedisOAuth2AuthorizationConsentService.buildKey(registeredClientId, principalName));
        return ObjectUtils.isEmpty((Object)result) ? null : (OAuth2AuthorizationConsent)result;
    }

    private static String buildKey(String registeredClientId, String principalName) {
        return "token:consent:" + registeredClientId + ":" + principalName;
    }

    private static String buildKey(OAuth2AuthorizationConsent authorizationConsent) {
        return RedisOAuth2AuthorizationConsentService.buildKey(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
    }
}

