/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.grant.username;

import cn.bbwres.biscuit.security.oauth2.grant.AbstractGrantAuthenticationProvider;
import cn.bbwres.biscuit.security.oauth2.grant.username.UsernamePasswordGrantAuthenticationToken;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.ObjectUtils;

public class UsernamePasswordGrantAuthenticationProvider
extends AbstractGrantAuthenticationProvider {
    private final AuthenticationProvider authenticationProvider;

    public UsernamePasswordGrantAuthenticationProvider(OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<?> tokenGenerator, AuthenticationProvider authenticationProvider) {
        super(authorizationService, tokenGenerator);
        this.authenticationProvider = authenticationProvider;
    }

    @Override
    protected Authentication authenticateHandler(RegisteredClient registeredClient, OAuth2AuthorizationGrantAuthenticationToken oauth2AuthorizationGrantAuthentication) throws AuthenticationException {
        UsernamePasswordGrantAuthenticationToken customCodeGrantAuthentication = (UsernamePasswordGrantAuthenticationToken)oauth2AuthorizationGrantAuthentication;
        String username = customCodeGrantAuthentication.getUsername();
        username = String.join((CharSequence)",", Base64.getEncoder().encodeToString(username.getBytes(StandardCharsets.UTF_8)), registeredClient.getClientId());
        if (!ObjectUtils.isEmpty((Object)customCodeGrantAuthentication.getTenantId())) {
            username = String.join((CharSequence)",", username, customCodeGrantAuthentication.getTenantId());
        }
        UsernamePasswordAuthenticationToken authRequest = UsernamePasswordAuthenticationToken.unauthenticated((Object)username, (Object)customCodeGrantAuthentication.getPassword());
        customCodeGrantAuthentication.setPassword(null);
        return this.authenticationProvider.authenticate((Authentication)authRequest);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordGrantAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

