/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.grant.username;

import cn.bbwres.biscuit.security.oauth2.grant.username.UsernamePasswordGrantAuthenticationToken;
import cn.bbwres.biscuit.security.oauth2.utils.ParamsUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class UsernamePasswordGrantAuthenticationConverter
implements AuthenticationConverter {
    public Authentication convert(HttpServletRequest request) {
        String grantType = request.getParameter("grant_type");
        if (!UsernamePasswordGrantAuthenticationToken.PASSWORD.getValue().equals(grantType)) {
            return null;
        }
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        MultiValueMap<String, String> parameters = ParamsUtil.getFormParameters(request);
        String username = (String)parameters.getFirst((Object)"username");
        if (!StringUtils.hasText((String)username) || ((List)parameters.get((Object)"username")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        String password = (String)parameters.getFirst((Object)"password");
        if (!StringUtils.hasText((String)password) || ((List)parameters.get((Object)"password")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        String tenantId = (String)parameters.getFirst((Object)"tenant_id");
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>(8);
        parameters.forEach((key, value) -> {
            if (!(key.equals("grant_type") || key.equals("client_id") || key.equals("code"))) {
                additionalParameters.put((String)key, value.getFirst());
            }
        });
        return new UsernamePasswordGrantAuthenticationToken(clientPrincipal, additionalParameters, username, password, tenantId);
    }
}

