/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.grant;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;

public abstract class AbstractGrantAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2TokenGenerator<?> tokenGenerator;
    private static final OAuth2TokenType ID_TOKEN_TOKEN_TYPE = new OAuth2TokenType("id_token");

    public AbstractGrantAuthenticationProvider(OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<?> tokenGenerator) {
        this.authorizationService = authorizationService;
        this.tokenGenerator = tokenGenerator;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OidcIdToken idToken;
        OAuth2AuthorizationGrantAuthenticationToken oauth2AuthorizationGrantAuthentication = (OAuth2AuthorizationGrantAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = this.getAuthenticatedClientElseThrowInvalidClient(authentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (!registeredClient.getAuthorizationGrantTypes().contains(oauth2AuthorizationGrantAuthentication.getGrantType())) {
            throw new OAuth2AuthenticationException("unauthorized_client");
        }
        Authentication userAuthenticate = this.authenticateHandler(registeredClient, oauth2AuthorizationGrantAuthentication);
        DefaultOAuth2TokenContext.Builder tokenContextBuilder = (DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal(userAuthenticate)).authorizedScopes(registeredClient.getScopes())).authorizationServerContext(AuthorizationServerContextHolder.getContext())).authorizationGrantType(oauth2AuthorizationGrantAuthentication.getGrantType())).authorizationGrant(authentication);
        DefaultOAuth2TokenContext tokenContext = ((DefaultOAuth2TokenContext.Builder)tokenContextBuilder.tokenType(OAuth2TokenType.ACCESS_TOKEN)).build();
        OAuth2Token generatedAccessToken = this.tokenGenerator.generate((OAuth2TokenContext)tokenContext);
        if (generatedAccessToken == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the access token.", null);
            throw new OAuth2AuthenticationException(error);
        }
        OAuth2Authorization.Builder authorizationBuilder = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).principalName(userAuthenticate.getName()).attributes(attrs -> attrs.put(Principal.class.getName(), userAuthenticate)).authorizationGrantType(tokenContext.getAuthorizationGrantType());
        HashMap additionalParameters = new HashMap(16);
        if (generatedAccessToken instanceof ClaimAccessor) {
            ClaimAccessor claimAccessor = (ClaimAccessor)generatedAccessToken;
            Map claims = claimAccessor.getClaims();
            for (String key : claims.keySet()) {
                if (!key.startsWith("custom_")) continue;
                additionalParameters.put(key, claims.get(key));
            }
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, generatedAccessToken.getTokenValue(), generatedAccessToken.getIssuedAt(), generatedAccessToken.getExpiresAt(), registeredClient.getScopes());
        OAuth2TokenFormat accessTokenFormat = registeredClient.getTokenSettings().getAccessTokenFormat();
        authorizationBuilder.token((OAuth2Token)accessToken, metadata -> {
            if (generatedAccessToken instanceof ClaimAccessor) {
                ClaimAccessor claimAccessor = (ClaimAccessor)generatedAccessToken;
                metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, claimAccessor.getClaims());
            }
            metadata.put(OAuth2Authorization.Token.INVALIDATED_METADATA_NAME, false);
            metadata.put(OAuth2TokenFormat.class.getName(), accessTokenFormat.getValue());
        });
        OAuth2RefreshToken refreshToken = null;
        if (registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.REFRESH_TOKEN) && !clientPrincipal.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.NONE)) {
            tokenContext = ((DefaultOAuth2TokenContext.Builder)tokenContextBuilder.tokenType(OAuth2TokenType.REFRESH_TOKEN)).build();
            refreshToken = (OAuth2RefreshToken)this.tokenGenerator.generate((OAuth2TokenContext)tokenContext);
            authorizationBuilder.refreshToken(refreshToken);
        }
        if (registeredClient.getScopes().contains("openid")) {
            tokenContext = ((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)tokenContextBuilder.tokenType(ID_TOKEN_TOKEN_TYPE)).authorization(authorizationBuilder.build())).build();
            OAuth2Token generatedIdToken = this.tokenGenerator.generate((OAuth2TokenContext)tokenContext);
            if (!(generatedIdToken instanceof Jwt)) {
                OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the ID token.", ERROR_URI);
                throw new OAuth2AuthenticationException(error);
            }
            idToken = new OidcIdToken(generatedIdToken.getTokenValue(), generatedIdToken.getIssuedAt(), generatedIdToken.getExpiresAt(), ((Jwt)generatedIdToken).getClaims());
            authorizationBuilder.token((OAuth2Token)idToken, metadata -> metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, idToken.getClaims()));
        } else {
            idToken = null;
        }
        if (idToken != null) {
            additionalParameters.put("id_token", idToken.getTokenValue());
        }
        OAuth2Authorization authorization = authorizationBuilder.build();
        this.authorizationService.save(authorization);
        return new OAuth2AccessTokenAuthenticationToken(registeredClient, (Authentication)clientPrincipal, accessToken, refreshToken, additionalParameters);
    }

    protected abstract Authentication authenticateHandler(RegisteredClient var1, OAuth2AuthorizationGrantAuthenticationToken var2) throws AuthenticationException;

    private OAuth2ClientAuthenticationToken getAuthenticatedClientElseThrowInvalidClient(Authentication authentication) {
        OAuth2ClientAuthenticationToken clientPrincipal = null;
        if (OAuth2ClientAuthenticationToken.class.isAssignableFrom(authentication.getPrincipal().getClass())) {
            clientPrincipal = (OAuth2ClientAuthenticationToken)authentication.getPrincipal();
        }
        if (clientPrincipal != null && clientPrincipal.isAuthenticated()) {
            return clientPrincipal;
        }
        throw new OAuth2AuthenticationException("invalid_client");
    }
}

