/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.event;

import cn.bbwres.biscuit.security.oauth2.event.AuthenticationLoginService;
import cn.bbwres.biscuit.security.oauth2.vo.AuthUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationFailureProviderNotFoundEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.AuthenticationException;

public class AuthenticationLoginEventListener {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationLoginEventListener.class);
    private final AuthenticationLoginService authenticationLoginService;

    public AuthenticationLoginEventListener(AuthenticationLoginService authenticationLoginService) {
        this.authenticationLoginService = authenticationLoginService;
    }

    @EventListener
    public void successEvent(AuthenticationSuccessEvent event) {
        Object object;
        if (event.getAuthentication().getDetails() != null && (object = event.getAuthentication().getPrincipal()) instanceof AuthUser) {
            AuthUser authUser = (AuthUser)((Object)object);
            log.info("\u5f53\u524d\u7528\u6237:{} \u767b\u5f55\u6210\u529f\u7684\uff01", (Object)authUser);
            this.authenticationLoginService.loginSuccess(authUser);
        }
    }

    @EventListener
    public void failureBadCredentialsEvent(AbstractAuthenticationFailureEvent event) {
        if (event instanceof AuthenticationFailureProviderNotFoundEvent) {
            return;
        }
        if (event.getAuthentication().getDetails() != null) {
            String username = event.getAuthentication().getName();
            AuthenticationException errorMessage = event.getException();
            log.info("\u5f53\u524d\u7528\u6237:{} \u767b\u5f55\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0:{}", (Object)username, (Object)errorMessage.getMessage());
            this.authenticationLoginService.loginFail(username, errorMessage);
        }
    }
}

