/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.config;

import cn.bbwres.biscuit.security.oauth2.grant.CustomAuthenticationGrant;
import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import cn.bbwres.biscuit.security.oauth2.web.CustomLoginUrlAuthenticationEntryPoint;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ObjectUtils;

@AutoConfiguration
public class Oauth2Config {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Oauth2Config.class);

    @Bean
    @ConditionalOnMissingBean
    public AuthorizationServerSettings authorizationServerSettings() {
        return AuthorizationServerSettings.builder().build();
    }

    @Bean
    public CustomLoginUrlAuthenticationEntryPoint customLoginUrlAuthenticationEntryPoint(BiscuitSecurityProperties biscuitSecurityProperties, AuthorizationServerSettings authorizationServerSettings, ObjectProvider<MessageSourceAccessor> messageSourceAccessorObjectProvider) {
        return new CustomLoginUrlAuthenticationEntryPoint(biscuitSecurityProperties.getLoginUrl(), authorizationServerSettings, messageSourceAccessorObjectProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2TokenGenerator<? extends OAuth2Token> oauth2TokenGenerator(JWKSource<SecurityContext> jwkSource, OAuth2TokenCustomizer<OAuth2TokenClaimsContext> accessTokenCustomizer) {
        OAuth2AccessTokenGenerator oAuth2AccessTokenGenerator = new OAuth2AccessTokenGenerator();
        oAuth2AccessTokenGenerator.setAccessTokenCustomizer(accessTokenCustomizer);
        return new DelegatingOAuth2TokenGenerator(new OAuth2TokenGenerator[]{new JwtGenerator((JwtEncoder)new NimbusJwtEncoder(jwkSource)), oAuth2AccessTokenGenerator, new OAuth2RefreshTokenGenerator()});
    }

    @Bean
    @Order(value=-10)
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http, ObjectProvider<List<CustomAuthenticationGrant>> customAuthenticationGrants, CustomLoginUrlAuthenticationEntryPoint customLoginUrlAuthenticationEntryPoint) throws Exception {
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = OAuth2AuthorizationServerConfigurer.authorizationServer();
        ((HttpSecurity)http.securityMatcher(authorizationServerConfigurer.getEndpointsMatcher()).with((SecurityConfigurerAdapter)authorizationServerConfigurer, authorizationServer -> authorizationServer.tokenEndpoint(tokenEndpoint -> {
            List customAuthentications = (List)customAuthenticationGrants.getIfAvailable();
            if (!ObjectUtils.isEmpty((Object)customAuthentications)) {
                customAuthentications.forEach(custom -> {
                    if (!ObjectUtils.isEmpty((Object)custom.getCustomAuthenticationConverter())) {
                        tokenEndpoint.accessTokenRequestConverter(custom.getCustomAuthenticationConverter());
                    }
                    if (!ObjectUtils.isEmpty((Object)custom.getCustomAuthenticationProvider())) {
                        tokenEndpoint.authenticationProvider(custom.getCustomAuthenticationProvider());
                    }
                });
            }
        }).oidc(Customizer.withDefaults()))).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated()).exceptionHandling(exceptions -> exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)customLoginUrlAuthenticationEntryPoint, (RequestMatcher)new MediaTypeRequestMatcher(new MediaType[]{MediaType.TEXT_HTML})));
        return (SecurityFilterChain)http.build();
    }
}

