/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2.config;

import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import cn.bbwres.biscuit.security.oauth2.service.redis.RedisOAuth2AuthorizationConsentService;
import cn.bbwres.biscuit.security.oauth2.service.redis.RedisOAuth2AuthorizationService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.InMemoryOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;

@AutoConfiguration
public class Oauth2AuthorizationServiceConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Oauth2AuthorizationServiceConfig.class);

    @Configuration
    @ConditionalOnProperty(prefix="biscuit.security", name={"token-store-type"}, havingValue="jdbc")
    @ConditionalOnClass(value={JdbcOperations.class})
    public static class JdbcOauth2AuthorizationServiceConfig {
        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationService jdbcOauth2AuthorizationService(JdbcOperations jdbcOperations, RegisteredClientRepository registeredClientRepository) {
            return new JdbcOAuth2AuthorizationService(jdbcOperations, registeredClientRepository);
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationConsentService authorizationConsentService(JdbcOperations jdbcOperations, RegisteredClientRepository registeredClientRepository) {
            return new JdbcOAuth2AuthorizationConsentService(jdbcOperations, registeredClientRepository);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="biscuit.security", name={"token-store-type"}, havingValue="redis")
    @ConditionalOnClass(value={RedisOperations.class})
    public static class RedisOauth2AuthorizationServiceConfig {
        @Bean
        public OAuth2AuthorizationService authorizationService(RegisteredClientRepository registeredClientRepository, @Qualifier(value="oauth2RedisTemplate") RedisTemplate<Object, Object> redisTemplate, BiscuitSecurityProperties biscuitSecurityProperties) {
            return new RedisOAuth2AuthorizationService(registeredClientRepository, (RedisOperations<Object, Object>)redisTemplate, biscuitSecurityProperties);
        }

        @Bean
        public OAuth2AuthorizationConsentService authorizationConsentService(@Qualifier(value="oauth2RedisTemplate") RedisTemplate<Object, Object> redisTemplate, BiscuitSecurityProperties biscuitSecurityProperties) {
            return new RedisOAuth2AuthorizationConsentService((RedisOperations<Object, Object>)redisTemplate, biscuitSecurityProperties);
        }

        @Bean(value={"oauth2RedisTemplate"})
        public RedisTemplate<Object, Object> oauth2RedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            RedisTemplate redisTemplate = new RedisTemplate();
            redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            redisTemplate.setConnectionFactory(redisConnectionFactory);
            return redisTemplate;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="biscuit.security", name={"token-store-type"}, havingValue="in_memory")
    public static class InMemoryOauth2AuthorizationServiceConfig {
        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationService inMemoryOauth2AuthorizationService() {
            return new InMemoryOAuth2AuthorizationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2AuthorizationConsentService authorizationConsentService() {
            return new InMemoryOAuth2AuthorizationConsentService();
        }
    }
}

