/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.redis.JdkSerializationStrategy;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStoreSerializationStrategy;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class RedisTokenStore
extends org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore {
    private static final String REFRESH_AUTH = "refresh_auth:";
    private static final String REFRESH = "refresh:";
    private static final String REFRESH_TO_ACCESS = "refresh_to_access:";
    private static final String UNAME_TO_REFRESH = "uname_to_refresh:";
    private static final boolean springDataRedis_2_0 = ClassUtils.isPresent((String)"org.springframework.data.redis.connection.RedisStandaloneConfiguration", (ClassLoader)org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore.class.getClassLoader());
    private final RedisConnectionFactory connectionFactory;
    private RedisTokenStoreSerializationStrategy serializationStrategy = new JdkSerializationStrategy();
    private String prefix = "";
    private Method redisConnectionSet_2_0;

    public RedisTokenStore(RedisConnectionFactory connectionFactory) {
        super(connectionFactory);
        this.connectionFactory = connectionFactory;
        if (springDataRedis_2_0) {
            this.loadRedisConnectionMethods_2_0_a();
        }
    }

    public void setSerializationStrategy(RedisTokenStoreSerializationStrategy serializationStrategy) {
        this.serializationStrategy = serializationStrategy;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private void loadRedisConnectionMethods_2_0_a() {
        this.redisConnectionSet_2_0 = ReflectionUtils.findMethod(RedisConnection.class, (String)"set", (Class[])new Class[]{byte[].class, byte[].class});
    }

    private RedisConnection getConnection() {
        return this.connectionFactory.getConnection();
    }

    private byte[] serialize(Object object) {
        return this.serializationStrategy.serialize(object);
    }

    private byte[] serializeKey(String object) {
        return this.serialize(this.prefix + object);
    }

    private OAuth2Authentication deserializeAuthentication(byte[] bytes) {
        return (OAuth2Authentication)this.serializationStrategy.deserialize(bytes, OAuth2Authentication.class);
    }

    private OAuth2RefreshToken deserializeRefreshToken(byte[] bytes) {
        return (OAuth2RefreshToken)this.serializationStrategy.deserialize(bytes, OAuth2RefreshToken.class);
    }

    private byte[] serialize(String string) {
        return this.serializationStrategy.serialize(string);
    }

    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        byte[] refreshKey = this.serializeKey(REFRESH + refreshToken.getValue());
        byte[] refreshAuthKey = this.serializeKey(REFRESH_AUTH + refreshToken.getValue());
        byte[] approvalKey = this.serializeKey(UNAME_TO_REFRESH + RedisTokenStore.getApprovalKey(authentication));
        byte[] serializedRefreshToken = this.serialize(refreshToken);
        try (RedisConnection conn = this.getConnection();){
            ExpiringOAuth2RefreshToken expiringRefreshToken;
            Date expiration;
            conn.openPipeline();
            if (springDataRedis_2_0) {
                try {
                    this.redisConnectionSet_2_0.invoke((Object)conn, refreshKey, serializedRefreshToken);
                    this.redisConnectionSet_2_0.invoke((Object)conn, refreshAuthKey, this.serialize(authentication));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                conn.set(refreshKey, serializedRefreshToken);
                conn.set(refreshAuthKey, this.serialize(authentication));
            }
            if (!authentication.isClientOnly()) {
                conn.sAdd(approvalKey, (byte[][])new byte[][]{serializedRefreshToken});
            }
            if (refreshToken instanceof ExpiringOAuth2RefreshToken && (expiration = (expiringRefreshToken = (ExpiringOAuth2RefreshToken)refreshToken).getExpiration()) != null) {
                long seconds = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
                conn.expire(refreshKey, seconds);
                conn.expire(refreshAuthKey, seconds);
                conn.expire(approvalKey, seconds);
            }
            conn.closePipeline();
        }
    }

    private static String getApprovalKey(OAuth2Authentication authentication) {
        String userName = authentication.getUserAuthentication() == null ? "" : authentication.getUserAuthentication().getName();
        return RedisTokenStore.getApprovalKey(authentication.getOAuth2Request().getClientId(), userName);
    }

    private static String getApprovalKey(String clientId, String userName) {
        return clientId + (String)(userName == null ? "" : ":" + userName);
    }

    public void removeRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeRefreshToken(refreshToken.getValue());
    }

    public void removeRefreshToken(String tokenValue) {
        byte[] refreshKey = this.serializeKey(REFRESH + tokenValue);
        byte[] refreshAuthKey = this.serializeKey(REFRESH_AUTH + tokenValue);
        byte[] refresh2AccessKey = this.serializeKey(REFRESH_TO_ACCESS + tokenValue);
        try (RedisConnection conn = this.getConnection();){
            conn.openPipeline();
            conn.get(refreshKey);
            conn.get(refreshAuthKey);
            conn.del((byte[][])new byte[][]{refreshKey});
            conn.del((byte[][])new byte[][]{refreshAuthKey});
            conn.del((byte[][])new byte[][]{refresh2AccessKey});
            List results = conn.closePipeline();
            byte[] refresh = (byte[])results.get(0);
            byte[] auth = (byte[])results.get(1);
            OAuth2Authentication authentication = this.deserializeAuthentication(auth);
            if (authentication != null) {
                byte[] unameKey = this.serializeKey(UNAME_TO_REFRESH + RedisTokenStore.getApprovalKey(authentication));
                conn.sRem(unameKey, (byte[][])new byte[][]{refresh});
            }
        }
    }

    public Collection<OAuth2RefreshToken> findRefreshTokensByClientIdAndUserName(String clientId, String userName) {
        List<byte[]> byteList;
        byte[] approvalKey = this.serializeKey(UNAME_TO_REFRESH + RedisTokenStore.getApprovalKey(clientId, userName));
        try (RedisConnection conn = this.getConnection();){
            byteList = this.getByteLists(approvalKey, conn);
        }
        if (byteList.size() == 0) {
            return Collections.emptySet();
        }
        ArrayList<OAuth2RefreshToken> refreshTokens = new ArrayList<OAuth2RefreshToken>(byteList.size());
        for (byte[] bytes : byteList) {
            OAuth2RefreshToken refreshToken = this.deserializeRefreshToken(bytes);
            refreshTokens.add(refreshToken);
        }
        return Collections.unmodifiableCollection(refreshTokens);
    }

    private List<byte[]> getByteLists(byte[] approvalKey, RedisConnection conn) {
        Long size = conn.sCard(approvalKey);
        assert (size != null);
        ArrayList<byte[]> byteList = new ArrayList<byte[]>(size.intValue());
        Cursor cursor = conn.sScan(approvalKey, ScanOptions.NONE);
        while (cursor.hasNext()) {
            byteList.add((byte[])cursor.next());
        }
        return byteList;
    }
}

