/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2;

import cn.bbwres.biscuit.security.oauth2.AuthorizationServerConfiguration;
import cn.bbwres.biscuit.security.oauth2.MyDefaultTokenServices;
import cn.bbwres.biscuit.security.oauth2.RedisTokenStore;
import cn.bbwres.biscuit.security.oauth2.event.AuthenticationLoginEventListener;
import cn.bbwres.biscuit.security.oauth2.event.AuthenticationLoginService;
import cn.bbwres.biscuit.security.oauth2.event.DefaultAuthenticationLoginServiceImpl;
import cn.bbwres.biscuit.security.oauth2.granter.EnhancerTokenGranter;
import cn.bbwres.biscuit.security.oauth2.handler.Oauth2ExceptionConvertErrorCode;
import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import cn.bbwres.biscuit.security.oauth2.vo.AuthUser;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.JdbcAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.RedisAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

@AutoConfiguration
@EnableAuthorizationServer
@EnableConfigurationProperties(value={BiscuitSecurityProperties.class})
public class BiscuitSecurityConfig {
    @Bean
    @Order(value=10)
    public TokenEnhancer tokenEnhancer() {
        return (accessToken, authentication) -> {
            HashMap<String, Object> additionalInfo = new HashMap<String, Object>(8);
            additionalInfo.put("expires_at", accessToken.getExpiration());
            if (authentication.getPrincipal() instanceof AuthUser) {
                additionalInfo.put("zh_name", ((AuthUser)((Object)((Object)authentication.getPrincipal()))).getZhName());
                additionalInfo.put("user_id", ((AuthUser)((Object)((Object)authentication.getPrincipal()))).getUserId());
                additionalInfo.put("tenant_id", ((AuthUser)((Object)((Object)authentication.getPrincipal()))).getTenantId());
            }
            ((DefaultOAuth2AccessToken)accessToken).setAdditionalInformation(additionalInfo);
            return accessToken;
        };
    }

    @Bean
    public TokenEnhancerChain tokenEnhancerChain(List<TokenEnhancer> tokenEnhancers) {
        TokenEnhancerChain tokenEnhancerChain = new TokenEnhancerChain();
        tokenEnhancerChain.setTokenEnhancers(tokenEnhancers);
        return tokenEnhancerChain;
    }

    @Bean
    public AuthenticationManager authenticationManagerBean(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    public AuthorizationServerTokenServices defaultTokenServices(TokenStore tokenStore, ClientDetailsService clientDetailsService, AuthenticationManager authenticationManager, TokenEnhancerChain tokenEnhancerChain, BiscuitSecurityProperties biscuitSecurityProperties) {
        MyDefaultTokenServices tokenServices = new MyDefaultTokenServices();
        tokenServices.setTokenStore(tokenStore);
        tokenServices.setSupportRefreshToken(biscuitSecurityProperties.getSupportRefreshToken());
        tokenServices.setReuseRefreshToken(biscuitSecurityProperties.getReuseRefreshToken());
        tokenServices.setClientDetailsService(clientDetailsService);
        tokenServices.setTokenEnhancer((TokenEnhancer)tokenEnhancerChain);
        tokenServices.setSingleClientToken(biscuitSecurityProperties.getSingleClientToken());
        tokenServices.setAuthenticationManager(authenticationManager);
        return tokenServices;
    }

    @Bean
    public PasswordEncoder passwordEncoder(BiscuitSecurityProperties biscuitSecurityProperties) {
        return new BCryptPasswordEncoder(biscuitSecurityProperties.getPasswordStrength().intValue());
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationLoginService authenticationLoginService() {
        return new DefaultAuthenticationLoginServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationLoginEventListener authenticationLoginEventListener(AuthenticationLoginService authenticationLoginService) {
        return new AuthenticationLoginEventListener(authenticationLoginService);
    }

    @Bean
    public AuthorizationServerConfigurerAdapter authorizationServerConfiguration(TokenStore tokenStore, ClientDetailsService myClientDetailsService, AuthenticationManager authenticationManager, TokenEnhancerChain tokenEnhancerChain, BiscuitSecurityProperties biscuitSecurityProperties, UserDetailsService userDetailsService, AuthorizationServerTokenServices defaultTokenServices, AuthorizationCodeServices authorizationCodeServices, List<EnhancerTokenGranter> enhancerTokenGranters) {
        return new AuthorizationServerConfiguration(myClientDetailsService, biscuitSecurityProperties, tokenStore, authenticationManager, tokenEnhancerChain, userDetailsService, defaultTokenServices, authorizationCodeServices, enhancerTokenGranters);
    }

    @Bean(value={"oauth2ExceptionConvertErrorCode"})
    public Oauth2ExceptionConvertErrorCode oauth2ExceptionConvertErrorCode() {
        return new Oauth2ExceptionConvertErrorCode();
    }

    @Configuration
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnProperty(prefix="biscuit.security", name={"authorization-code-store-type"}, havingValue="jdbc")
    public static class JdbcAuthorizationCodeConfig {
        @Bean
        @ConditionalOnMissingBean
        public AuthorizationCodeServices authorizationCodeServices(DataSource dataSource) {
            return new JdbcAuthorizationCodeServices(dataSource);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    @ConditionalOnProperty(prefix="biscuit.security", name={"authorization-code-store-type"}, havingValue="redis", matchIfMissing=true)
    public static class RedisAuthorizationCodeConfig {
        @Bean
        @ConditionalOnMissingBean
        public AuthorizationCodeServices authorizationCodeServices(RedisConnectionFactory connectionFactory) {
            return new RedisAuthorizationCodeServices(connectionFactory);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="biscuit.security", name={"token-store-type"}, havingValue="jwt")
    public static class JwtToken {
        @Bean
        @Order(value=900)
        public JwtAccessTokenConverter jwtAccessTokenConverter(BiscuitSecurityProperties biscuitSecurityProperties) {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            converter.setSigningKey(biscuitSecurityProperties.getJwtPrivateKey());
            converter.setVerifierKey(biscuitSecurityProperties.getJwtPublicKey());
            return converter;
        }

        @Bean
        public TokenStore jwtTokenStore(JwtAccessTokenConverter jwtAccessTokenConverter) {
            return new JwtTokenStore(jwtAccessTokenConverter);
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="biscuit.security", name={"token-store-type"}, havingValue="redis")
    public static class RedisToken {
        @Bean
        public TokenStore redisTokenStore(RedisConnectionFactory connectionFactory) {
            return new RedisTokenStore(connectionFactory);
        }
    }
}

