/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.security.oauth2;

import cn.bbwres.biscuit.security.oauth2.granter.EnhancerTokenGranter;
import cn.bbwres.biscuit.security.oauth2.properties.BiscuitSecurityProperties;
import cn.bbwres.biscuit.security.oauth2.properties.TokenStoreType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.password.ResourceOwnerPasswordTokenGranter;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.CollectionUtils;

public class AuthorizationServerConfiguration
extends AuthorizationServerConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationServerConfiguration.class);
    private final ClientDetailsService clientDetailsService;
    private final BiscuitSecurityProperties biscuitSecurityProperties;
    private final TokenStore tokenStore;
    private final AuthenticationManager authenticationManager;
    private final TokenEnhancerChain tokenEnhancerChain;
    private final UserDetailsService userDetailsService;
    private final AuthorizationServerTokenServices defaultTokenServices;
    private final List<EnhancerTokenGranter> enhancerTokenGranters;
    private final AuthorizationCodeServices authorizationCodeServices;

    public AuthorizationServerConfiguration(ClientDetailsService clientDetailsService, BiscuitSecurityProperties biscuitSecurityProperties, TokenStore tokenStore, AuthenticationManager authenticationManager, TokenEnhancerChain tokenEnhancerChain, UserDetailsService userDetailsService, AuthorizationServerTokenServices defaultTokenServices, AuthorizationCodeServices authorizationCodeServices, List<EnhancerTokenGranter> enhancerTokenGranters) {
        this.clientDetailsService = clientDetailsService;
        this.biscuitSecurityProperties = biscuitSecurityProperties;
        this.tokenStore = tokenStore;
        this.authenticationManager = authenticationManager;
        this.tokenEnhancerChain = tokenEnhancerChain;
        this.userDetailsService = userDetailsService;
        this.defaultTokenServices = defaultTokenServices;
        this.authorizationCodeServices = authorizationCodeServices;
        this.enhancerTokenGranters = enhancerTokenGranters;
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.withClientDetails(this.clientDetailsService);
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints.allowedTokenEndpointRequestMethods(this.biscuitSecurityProperties.getAllowedTokenEndpointRequestMethods());
        endpoints.authenticationManager(this.authenticationManager).userDetailsService(this.userDetailsService).tokenStore(this.tokenStore).tokenEnhancer((TokenEnhancer)this.tokenEnhancerChain).setClientDetailsService(this.clientDetailsService);
        if (TokenStoreType.REDIS.equals((Object)this.biscuitSecurityProperties.getTokenStoreType())) {
            endpoints.tokenServices(this.defaultTokenServices);
        }
        endpoints.authorizationCodeServices(this.authorizationCodeServices);
        AuthorizationServerTokenServices tokenServices = endpoints.getTokenServices();
        OAuth2RequestFactory requestFactory = endpoints.getOAuth2RequestFactory();
        endpoints.tokenGranter((TokenGranter)new CompositeTokenGranter(this.getTokenGranters(this.clientDetailsService, tokenServices, requestFactory, endpoints.getTokenGranter())));
    }

    public List<TokenGranter> getTokenGranters(ClientDetailsService clientDetails, AuthorizationServerTokenServices tokenServices, final OAuth2RequestFactory requestFactory, TokenGranter tokenGranter) {
        ArrayList<TokenGranter> tokenGranters = new ArrayList<TokenGranter>();
        tokenGranters.add(tokenGranter);
        if (!CollectionUtils.isEmpty(this.enhancerTokenGranters)) {
            for (final EnhancerTokenGranter enhancerTokenGranter : this.enhancerTokenGranters) {
                Class<?> parentClazz = enhancerTokenGranter.parentClazz();
                if (ResourceOwnerPasswordTokenGranter.class.equals(parentClazz)) {
                    tokenGranters.add((TokenGranter)new ResourceOwnerPasswordTokenGranter(this.authenticationManager, tokenServices, clientDetails, requestFactory, enhancerTokenGranter.grantType()){

                        protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
                            enhancerTokenGranter.buildAuthentication(client, tokenRequest);
                            return super.getOAuth2Authentication(client, tokenRequest);
                        }
                    });
                }
                tokenGranters.add((TokenGranter)new AbstractTokenGranter(tokenServices, clientDetails, requestFactory, enhancerTokenGranter.grantType()){

                    public OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
                        Authentication authentication = enhancerTokenGranter.buildAuthentication(client, tokenRequest);
                        return new OAuth2Authentication(requestFactory.createOAuth2Request(client, tokenRequest), authentication);
                    }
                });
            }
        }
        return tokenGranters;
    }

    public void configure(AuthorizationServerSecurityConfigurer security) throws Exception {
        security.tokenKeyAccess(this.biscuitSecurityProperties.getTokenKeyAccessSecurity()).checkTokenAccess(this.biscuitSecurityProperties.getCheckTokenAccessSecurity()).allowFormAuthenticationForClients();
    }
}

