/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.scheduler.job;

import java.util.Map;
import lombok.Generated;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.MethodInvoker;

public class BeanInvokingJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeanInvokingJob.class);
    private ApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String targetBean = null;
        String targetMethod = null;
        try {
            log.debug("start");
            JobDataMap jobDataMap = context.getMergedJobDataMap();
            targetBean = jobDataMap.getString("TARGET_BEAN");
            log.debug("targetBean is " + targetBean);
            if (targetBean == null) {
                throw new JobExecutionException("targetBean cannot be null.", false);
            }
            targetMethod = jobDataMap.getString("TARGET_METHOD");
            log.debug("targetMethod is " + targetMethod);
            if (targetMethod == null) {
                throw new JobExecutionException("targetMethod cannot be null.", false);
            }
            Object bean = this.applicationContext.getBean(targetBean);
            log.debug("applicationContext resolved bean name/id [{}] to [{}]'", (Object)targetBean, bean);
            try {
                BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
                MutablePropertyValues pvs = new MutablePropertyValues();
                pvs.addPropertyValues((Map)context.getScheduler().getContext());
                pvs.addPropertyValues((Map)jobDataMap);
                bw.setPropertyValues((PropertyValues)pvs, true);
            }
            catch (SchedulerException ex) {
                throw new JobExecutionException((Throwable)ex);
            }
            MethodInvoker beanMethod = new MethodInvoker();
            beanMethod.setTargetObject(bean);
            beanMethod.setTargetMethod(targetMethod);
            if (jobDataMap.getBoolean("USE_CONTEXT")) {
                beanMethod.setArguments(new Object[]{context});
            }
            beanMethod.prepare();
            beanMethod.invoke();
        }
        catch (JobExecutionException jobExecutionException) {
            throw jobExecutionException;
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1[bean=[{}],method=[{}]\u6267\u884c\u5f02\u5e38\uff1a", new Object[]{targetBean, targetMethod, e});
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            log.debug("end");
        }
    }
}

