/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.scheduler;

import cn.bbwres.biscuit.scheduler.annotation.JobDataMap;
import cn.bbwres.biscuit.scheduler.annotation.JobDefinition;
import cn.bbwres.biscuit.scheduler.config.QuartzJdbcProperties;
import cn.bbwres.biscuit.scheduler.job.BeanInvokingJob;
import cn.bbwres.biscuit.scheduler.job.StatefulBeanInvokingJob;
import cn.bbwres.biscuit.scheduler.service.JobManagerService;
import cn.bbwres.biscuit.scheduler.service.JobManagerServiceImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.quartz.Calendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Configuration
@EnableConfigurationProperties(value={QuartzJdbcProperties.class})
public class JobAutoConfigure {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobAutoConfigure.class);

    @Bean
    @Primary
    @ConditionalOnProperty(prefix="spring.quartz.jdbc", name={"jobStoreType"}, havingValue="JDBC")
    public QuartzProperties quartzProperties(QuartzJdbcProperties quartzJdbcProperties) {
        QuartzProperties quartzProperties = new QuartzProperties();
        quartzProperties.setJobStoreType(quartzJdbcProperties.getJobStoreType());
        quartzProperties.setAutoStartup(quartzJdbcProperties.getAutoStartup().booleanValue());
        quartzProperties.setSchedulerName(quartzJdbcProperties.getSchedulerName());
        quartzProperties.setStartupDelay(quartzJdbcProperties.getStartupDelay());
        quartzProperties.setOverwriteExistingJobs(quartzJdbcProperties.getOverwriteExistingJobs().booleanValue());
        quartzProperties.setWaitForJobsToCompleteOnShutdown(quartzJdbcProperties.getWaitForJobsToCompleteOnShutdown().booleanValue());
        Map properties = quartzProperties.getProperties();
        properties.put("org.quartz.scheduler.instanceName", quartzJdbcProperties.getInstanceName());
        properties.put("org.quartz.scheduler.instanceId", quartzJdbcProperties.getInstanceId());
        properties.put("org.quartz.jobStore.class", quartzJdbcProperties.getJobStoreClass());
        if (!ObjectUtils.isEmpty((Object)quartzJdbcProperties.getDataSource())) {
            properties.put("org.quartz.jobStore.dataSource", quartzJdbcProperties.getDataSource());
        }
        properties.put("org.quartz.jobStore.driverDelegateClass", quartzJdbcProperties.getDriverDelegateClass());
        properties.put("org.quartz.jobStore.tablePrefix", quartzJdbcProperties.getTablePrefix());
        properties.put("org.quartz.jobStore.isClustered", quartzJdbcProperties.getIsClustered());
        properties.put("org.quartz.jobStore.clusterCheckinInterval", quartzJdbcProperties.getClusterCheckinInterval());
        properties.put("org.quartz.threadPool.threadCount", quartzJdbcProperties.getThreadCount());
        properties.put("org.quartz.threadPool.threadPriority", quartzJdbcProperties.getThreadPriority());
        properties.put("org.quartz.threadPool.class", quartzJdbcProperties.getThreadPoolClass());
        properties.put("org.quartz.jobStore.acquireTriggersWithinLock", quartzJdbcProperties.getAcquireTriggersWithinLock());
        if (!CollectionUtils.isEmpty(quartzJdbcProperties.getProperties())) {
            properties.putAll(quartzJdbcProperties.getProperties());
        }
        return quartzProperties;
    }

    @Bean
    public SchedulerFactoryBean quartzScheduler(QuartzProperties properties, ObjectProvider<SchedulerFactoryBeanCustomizer> customizers, Map<String, Calendar> calendars, ApplicationContext applicationContext, DataSource dataSource) {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        SpringBeanJobFactory jobFactory = new SpringBeanJobFactory();
        jobFactory.setApplicationContext(applicationContext);
        schedulerFactoryBean.setJobFactory((JobFactory)jobFactory);
        if (properties.getSchedulerName() != null) {
            schedulerFactoryBean.setSchedulerName(properties.getSchedulerName());
        }
        if (!properties.getProperties().containsKey("org.quartz.jobStore.dataSource")) {
            schedulerFactoryBean.setDataSource(dataSource);
        }
        schedulerFactoryBean.setAutoStartup(properties.isAutoStartup());
        schedulerFactoryBean.setStartupDelay((int)properties.getStartupDelay().getSeconds());
        schedulerFactoryBean.setWaitForJobsToCompleteOnShutdown(properties.isWaitForJobsToCompleteOnShutdown());
        schedulerFactoryBean.setOverwriteExistingJobs(properties.isOverwriteExistingJobs());
        if (!properties.getProperties().isEmpty()) {
            schedulerFactoryBean.setQuartzProperties(this.asProperties(properties.getProperties()));
        }
        this.setJobInfo(schedulerFactoryBean, applicationContext);
        schedulerFactoryBean.setCalendars(calendars);
        customizers.orderedStream().forEach(customizer -> customizer.customize(schedulerFactoryBean));
        return schedulerFactoryBean;
    }

    @Bean
    public JobManagerService jobManagerService(Scheduler scheduler) {
        return new JobManagerServiceImpl(scheduler);
    }

    private void setJobInfo(SchedulerFactoryBean schedulerFactoryBean, ApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansWithAnnotation(JobDefinition.class);
        if (CollectionUtils.isEmpty((Map)beans)) {
            log.info("\u5f53\u524d\u65e0\u5b9a\u65f6\u4efb\u52a1\u9700\u8981\u521d\u59cb\u5316");
            return;
        }
        ArrayList<JobDetail> jobDetails = new ArrayList<JobDetail>();
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (String beanName : beans.keySet()) {
            Object bean = beans.get(beanName);
            JobDefinition jobDefinition = bean.getClass().getAnnotation(JobDefinition.class);
            if (jobDefinition == null) continue;
            JobDetail jobDetail = this.buildJobDetail(jobDefinition, beanName);
            Trigger trigger = this.buildTrigger(jobDefinition, jobDetail);
            jobDetails.add(jobDetail);
            triggers.add(trigger);
        }
        schedulerFactoryBean.setJobDetails(jobDetails.toArray(new JobDetail[0]));
        schedulerFactoryBean.setTriggers(triggers.toArray(new Trigger[0]));
    }

    private Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }

    private JobDetail buildJobDetail(JobDefinition jobDefinition, String beanName) {
        org.quartz.JobDataMap jobDataMap = new org.quartz.JobDataMap();
        for (JobDataMap argument : jobDefinition.arguments()) {
            jobDataMap.put(argument.key(), argument.value());
        }
        jobDataMap.put("TARGET_BEAN", beanName);
        jobDataMap.put("TARGET_METHOD", jobDefinition.targetMethod());
        jobDataMap.put("USE_CONTEXT", jobDefinition.useContext());
        return JobBuilder.newJob(jobDefinition.concurrent() ? BeanInvokingJob.class : StatefulBeanInvokingJob.class).withIdentity(jobDefinition.jobName(), jobDefinition.group()).storeDurably().setJobData(jobDataMap).withDescription(jobDefinition.description()).build();
    }

    private Trigger buildTrigger(JobDefinition jobDefinition, JobDetail jobDetail) {
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)jobDefinition.cron());
        if (2 == jobDefinition.misfireInstruction()) {
            scheduleBuilder.withMisfireHandlingInstructionDoNothing();
        }
        if (1 == jobDefinition.misfireInstruction()) {
            scheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
        }
        if (-1 == jobDefinition.misfireInstruction()) {
            scheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
        }
        return TriggerBuilder.newTrigger().forJob(jobDetail).withDescription(jobDetail.getDescription()).withIdentity(jobDefinition.jobName() + "Trigger", jobDefinition.group()).withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }
}

