/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.scheduler.service;

import cn.bbwres.biscuit.scheduler.dto.TriggerInfo;
import cn.bbwres.biscuit.scheduler.service.JobManagerService;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerServiceImpl
implements JobManagerService {
    private static final Logger log = LoggerFactory.getLogger(JobManagerServiceImpl.class);
    private final Scheduler scheduler;

    @Override
    public List<TriggerInfo> queryAllTrigger() {
        try {
            List groups = this.scheduler.getTriggerGroupNames();
            HashSet triggerKeys = new HashSet(10);
            for (String group : groups) {
                triggerKeys.addAll(this.scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)group)));
            }
            return triggerKeys.parallelStream().map(new Function<TriggerKey, TriggerInfo>(){

                @Override
                public TriggerInfo apply(TriggerKey triggerKey) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    CronTrigger cronTrigger = (CronTrigger)JobManagerServiceImpl.this.scheduler.getTrigger(triggerKey);
                    return new TriggerInfo().setName(cronTrigger.getKey().getName()).setDescription(cronTrigger.getDescription()).setGroup(cronTrigger.getKey().getGroup()).setJobName(cronTrigger.getJobKey().getName()).setJobGroup(cronTrigger.getJobKey().getGroup()).setStatus(JobManagerServiceImpl.this.scheduler.getTriggerState(triggerKey).name()).setCronExpression(cronTrigger.getCronExpression()).setStartTime(cronTrigger.getStartTime() != null ? sdf.format(cronTrigger.getStartTime()) : null).setEndTime(cronTrigger.getEndTime() != null ? sdf.format(cronTrigger.getEndTime()) : null).setPreviousFireTime(cronTrigger.getPreviousFireTime() != null ? sdf.format(cronTrigger.getPreviousFireTime()) : null).setNextFireTime(cronTrigger.getNextFireTime() != null ? sdf.format(cronTrigger.getNextFireTime()) : null);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    @Override
    public JobDetail queryJobDetail(String jobName, String jobGroup) {
        try {
            return this.scheduler.getJobDetail(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean pausedTrigger(String triggerName, String triggerGroup) {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroup));
            return true;
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean pausedTriggers(List<TriggerInfo> triggerKeys) {
        try {
            for (TriggerInfo triggerKey : triggerKeys) {
                this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)triggerKey.getName(), (String)triggerKey.getGroup()));
            }
            return true;
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean resumeTrigger(String triggerName, String triggerGroup) {
        try {
            this.scheduler.resumeTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroup));
            return true;
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean resumeTriggers(List<TriggerInfo> triggerKeys) {
        try {
            for (TriggerInfo triggerKey : triggerKeys) {
                this.scheduler.resumeTrigger(TriggerKey.triggerKey((String)triggerKey.getName(), (String)triggerKey.getGroup()));
            }
            return true;
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean updateTriggerCron(String triggerName, String triggerGroup, String cron) {
        try {
            CronTrigger cronTrigger = (CronTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroup));
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
            scheduleBuilder.withMisfireHandlingInstructionDoNothing();
            this.scheduler.rescheduleJob(cronTrigger.getKey(), cronTrigger.getTriggerBuilder().withSchedule((ScheduleBuilder)scheduleBuilder).build());
            return true;
        }
        catch (Exception e) {
            log.info("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean triggerJob(String jobName, String jobGroup) {
        try {
            this.scheduler.triggerJob(JobKey.jobKey((String)jobName, (String)jobGroup));
            return true;
        }
        catch (Exception e) {
            log.info("\u7acb\u5373\u6267\u884c\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean triggerJobByTrigger(String triggerName, String triggerGroup) {
        try {
            JobKey jobKey = this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggerName, (String)triggerGroup)).getJobKey();
            return this.triggerJob(jobKey.getName(), jobKey.getGroup());
        }
        catch (Exception e) {
            log.info("\u7acb\u5373\u6267\u884c\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
            return false;
        }
    }

    public JobManagerServiceImpl(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

