/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.caches.redis.manager;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BiscuitRedisCacheManager
extends RedisCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiscuitRedisCacheManager.class);
    private final String delimitSymbol;

    public BiscuitRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation, String delimitSymbol) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, allowInFlightCacheCreation);
        this.delimitSymbol = delimitSymbol;
    }

    protected RedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        if (name.contains(this.delimitSymbol)) {
            String[] array = StringUtils.delimitedListToStringArray((String)name, (String)this.delimitSymbol);
            name = array[0];
            if (array.length > 1) {
                try {
                    long ttl = Long.parseLong(array[1]);
                    cacheConfig = cacheConfig.entryTtl(Duration.ofSeconds(ttl));
                }
                catch (Exception e) {
                    LOGGER.info("\u5f53\u524d\u7f13\u5b58\u7684ttl\u89e3\u6790\u5931\u8d25\uff01\u56e0\u6b64\u4f7f\u7528\u9ed8\u8ba4\u7684\u7f13\u5b58\u540d\u5b57\u548cttl!\u7f13\u5b58\u540d\u5b57\u4e3a:[{}],\u5931\u8d25\u539f\u56e0\u4e3a:[{}]", (Object)name, (Object)e.getMessage());
                }
            }
        }
        return super.createRedisCache(name, cacheConfig);
    }

    public static class BiscuitRedisCacheManagerBuilder {
        @Nullable
        private RedisCacheWriter cacheWriter;
        private CacheStatisticsCollector statisticsCollector = CacheStatisticsCollector.none();
        private RedisCacheConfiguration defaultCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        private final Map<String, RedisCacheConfiguration> initialCaches = new LinkedHashMap<String, RedisCacheConfiguration>();
        private boolean enableTransactions;
        boolean allowInFlightCacheCreation = true;
        private String delimitSymbol;

        private BiscuitRedisCacheManagerBuilder() {
        }

        private BiscuitRedisCacheManagerBuilder(RedisCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public static BiscuitRedisCacheManagerBuilder fromConnectionFactory(RedisConnectionFactory connectionFactory) {
            Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
            return new BiscuitRedisCacheManagerBuilder(RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)connectionFactory));
        }

        public static BiscuitRedisCacheManagerBuilder fromCacheWriter(RedisCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            return new BiscuitRedisCacheManagerBuilder(cacheWriter);
        }

        public BiscuitRedisCacheManagerBuilder cacheDefaults(RedisCacheConfiguration defaultCacheConfiguration) {
            Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
            this.defaultCacheConfiguration = defaultCacheConfiguration;
            return this;
        }

        public BiscuitRedisCacheManagerBuilder cacheWriter(RedisCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            this.cacheWriter = cacheWriter;
            return this;
        }

        public BiscuitRedisCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public BiscuitRedisCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            Assert.notNull(cacheNames, (String)"CacheNames must not be null!");
            cacheNames.forEach(it -> this.withCacheConfiguration((String)it, this.defaultCacheConfiguration));
            return this;
        }

        public BiscuitRedisCacheManagerBuilder withInitialCacheConfigurations(Map<String, RedisCacheConfiguration> cacheConfigurations) {
            Assert.notNull(cacheConfigurations, (String)"CacheConfigurations must not be null!");
            cacheConfigurations.forEach((cacheName, configuration) -> Assert.notNull((Object)configuration, (String)String.format("RedisCacheConfiguration for cache %s must not be null!", cacheName)));
            this.initialCaches.putAll(cacheConfigurations);
            return this;
        }

        public BiscuitRedisCacheManagerBuilder withCacheConfiguration(String cacheName, RedisCacheConfiguration cacheConfiguration) {
            Assert.notNull((Object)cacheName, (String)"CacheName must not be null!");
            Assert.notNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null!");
            this.initialCaches.put(cacheName, cacheConfiguration);
            return this;
        }

        public BiscuitRedisCacheManagerBuilder disableCreateOnMissingCache() {
            this.allowInFlightCacheCreation = false;
            return this;
        }

        public Set<String> getConfiguredCaches() {
            return Collections.unmodifiableSet(this.initialCaches.keySet());
        }

        public Optional<RedisCacheConfiguration> getCacheConfigurationFor(String cacheName) {
            return Optional.ofNullable(this.initialCaches.get(cacheName));
        }

        public BiscuitRedisCacheManagerBuilder enableStatistics() {
            this.statisticsCollector = CacheStatisticsCollector.create();
            return this;
        }

        public BiscuitRedisCacheManagerBuilder setDelimitSymbol(String delimitSymbol) {
            this.delimitSymbol = delimitSymbol;
            return this;
        }

        public BiscuitRedisCacheManager build() {
            Assert.state((this.cacheWriter != null ? 1 : 0) != 0, (String)"CacheWriter must not be null! You can provide one via 'RedisCacheManagerBuilder#cacheWriter(RedisCacheWriter)'.");
            RedisCacheWriter theCacheWriter = this.cacheWriter;
            if (!this.statisticsCollector.equals(CacheStatisticsCollector.none())) {
                theCacheWriter = this.cacheWriter.withStatisticsCollector(this.statisticsCollector);
            }
            BiscuitRedisCacheManager cm = new BiscuitRedisCacheManager(theCacheWriter, this.defaultCacheConfiguration, this.initialCaches, this.allowInFlightCacheCreation, this.delimitSymbol);
            cm.setTransactionAware(this.enableTransactions);
            return cm;
        }
    }
}

