/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.caches.redis;

import cn.bbwres.biscuit.caches.redis.BiscuitRedisProperties;
import cn.bbwres.biscuit.caches.redis.manager.BiscuitRedisCacheManager;
import cn.bbwres.biscuit.utils.JsonUtil;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableCaching
@AutoConfiguration
@EnableConfigurationProperties(value={BiscuitRedisProperties.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
public class RedisAutoConfigure {
    @Bean
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory connectionFactory, ObjectProvider<Jackson2JsonRedisSerializer<Object>> jackson2JsonRedisSerializer) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        jackson2JsonRedisSerializer.ifAvailable(serializer -> {
            template.setValueSerializer((RedisSerializer)serializer);
            template.setHashValueSerializer((RedisSerializer)serializer);
        });
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    @ConditionalOnProperty(prefix="biscuit.redis", name={"enable-json-serializer-value"}, havingValue="true", matchIfMissing=true)
    public Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer() {
        Jackson2JsonRedisSerializer serializer = new Jackson2JsonRedisSerializer(Object.class);
        serializer.setObjectMapper(JsonUtil.getObjectMapper());
        return serializer;
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory, Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer, BiscuitRedisProperties biscuitRedisProperties) {
        BiscuitRedisCacheManager.BiscuitRedisCacheManagerBuilder builder = BiscuitRedisCacheManager.BiscuitRedisCacheManagerBuilder.fromConnectionFactory(redisConnectionFactory).setDelimitSymbol(biscuitRedisProperties.getDelimitSymbol()).cacheDefaults(RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(jackson2JsonRedisSerializer)));
        return builder.build();
    }
}

