/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.operation.log.service.impl;

import cn.bbwres.biscuit.operation.log.annotation.OperationLog;
import cn.bbwres.biscuit.operation.log.entity.OperationLogEntity;
import cn.bbwres.biscuit.operation.log.service.EnhanceOperationLogService;
import cn.bbwres.biscuit.utils.NetworkUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class EnhanceOperationLogWebServiceImpl
implements EnhanceOperationLogService {
    private static final String[] CLIENT_IP_HTTP_HEADER_NAME = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static final String USER_AGENT = "User-Agent";

    protected HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return !(requestAttributes instanceof ServletRequestAttributes) ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    protected String getUserAgent(HttpServletRequest request) {
        String ua = request.getHeader(USER_AGENT);
        return ua != null ? ua : "";
    }

    public static String getClientIp(HttpServletRequest request) {
        return EnhanceOperationLogWebServiceImpl.getClientIpByHeader(request, CLIENT_IP_HTTP_HEADER_NAME);
    }

    public static String getClientIpByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String headerName : headerNames) {
            ip = request.getHeader(headerName);
            if (NetworkUtil.isUnknown((String)ip)) continue;
            return NetworkUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetworkUtil.getMultistageReverseProxyIp((String)ip);
    }

    @Override
    public void enhance(OperationLogEntity loggerMsg, OperationLog operateLog, ProceedingJoinPoint joinPoint, Object response, Throwable exception) {
        HttpServletRequest request = this.getRequest();
        if (Objects.isNull(request)) {
            return;
        }
        loggerMsg.setRequestMethod(request.getMethod());
        loggerMsg.setRequestUrl(request.getRequestURI());
        loggerMsg.setUserIp(EnhanceOperationLogWebServiceImpl.getClientIp(request));
        loggerMsg.setUserAgent(this.getUserAgent(request));
    }

    @Generated
    public EnhanceOperationLogWebServiceImpl() {
    }
}

