/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.operation.log.aspect;

import cn.bbwres.biscuit.operation.log.annotation.OperationLog;
import cn.bbwres.biscuit.operation.log.entity.OperationLogEntity;
import cn.bbwres.biscuit.operation.log.service.EnhanceOperationLogService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;

@Order(value=-20)
@Aspect
public class OperationLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationLogAspect.class);
    private static final Logger OPERATION_LOG = LoggerFactory.getLogger((String)"OPERATION_LOG");
    private static final ThreadLocal<String> CONTENT = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> EXT = new ThreadLocal();
    private final List<EnhanceOperationLogService> enhanceOperationLogServices;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public static void addExt(String key, Object value) {
        if (EXT.get() == null) {
            EXT.set(new HashMap(8));
        }
        EXT.get().put(key, value);
    }

    public static void setContent(String content) {
        CONTENT.set(content);
    }

    public static void clearThreadLocal() {
        CONTENT.remove();
        EXT.remove();
    }

    @Around(value="@annotation(operateLog)")
    public Object around(ProceedingJoinPoint joinPoint, OperationLog operateLog) throws Throwable {
        LocalDateTime startTime = LocalDateTime.now();
        try {
            OperationLogAspect.clearThreadLocal();
            Object result = joinPoint.proceed();
            this.buildLoggerMsg(joinPoint, result, startTime, null, operateLog);
            Object object = result;
            return object;
        }
        catch (Throwable exception) {
            this.buildLoggerMsg(joinPoint, null, startTime, exception, operateLog);
            throw exception;
        }
        finally {
            OperationLogAspect.clearThreadLocal();
        }
    }

    private void buildLoggerMsg(ProceedingJoinPoint joinPoint, Object response, LocalDateTime startTime, Throwable exception, OperationLog operateLog) {
        try {
            OperationLogEntity loggerMsg = new OperationLogEntity().setCreateTime(startTime.format(DATE_TIME_FORMATTER));
            loggerMsg.setDuration(Duration.between(startTime, LocalDateTime.now()).toMillis());
            loggerMsg.setContent(CONTENT.get());
            loggerMsg.setExts(EXT.get());
            if (!CollectionUtils.isEmpty(this.enhanceOperationLogServices)) {
                for (EnhanceOperationLogService enhanceOperationLogService : this.enhanceOperationLogServices) {
                    enhanceOperationLogService.enhance(loggerMsg, operateLog, joinPoint, response, exception);
                }
            }
            OPERATION_LOG.info("{}", (Object)loggerMsg);
        }
        catch (Exception e) {
            log.warn("\u65e5\u5fd7\u5904\u7406\u5f02\u5e38![{}]", (Object)e.getMessage(), (Object)e);
        }
    }

    @Generated
    public OperationLogAspect(List<EnhanceOperationLogService> enhanceOperationLogServices) {
        this.enhanceOperationLogServices = enhanceOperationLogServices;
    }
}

