/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.operation.log.service.impl;

import cn.bbwres.biscuit.operation.log.annotation.OperationLog;
import cn.bbwres.biscuit.operation.log.entity.OperationLogEntity;
import cn.bbwres.biscuit.operation.log.service.EnhanceOperationLogService;
import cn.bbwres.biscuit.utils.JsonUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.boot.logging.LogLevel;

public class EnhanceOperationLogParamsServiceImpl
implements EnhanceOperationLogService {
    @Override
    public void enhance(OperationLogEntity loggerMsg, OperationLog operateLog, ProceedingJoinPoint joinPoint, Object response, Throwable exception) {
        if (operateLog.logArgs() && ArrayUtils.isNotEmpty((Object[])joinPoint.getArgs())) {
            ArrayList<Object> objectList = new ArrayList<Object>(16);
            for (int i = 0; i < joinPoint.getArgs().length; ++i) {
                if (ArrayUtils.contains((int[])operateLog.ignoreRequestParamsIdx(), (int)i)) continue;
                objectList.add(joinPoint.getArgs()[i]);
            }
            loggerMsg.setRequestMsg(JsonUtil.toJson(objectList));
        }
        if (Objects.nonNull(exception)) {
            loggerMsg.setExceptionMsg(StringUtils.left((String)exception.getMessage(), (int)255));
            loggerMsg.setLoggerLevel(LogLevel.ERROR.name());
        }
        if (Objects.nonNull(response) && !(response instanceof OutputStream) && !operateLog.ignoreResponseParams()) {
            loggerMsg.setResponseMsg(JsonUtil.toJson((Object)response));
        }
    }
}

