/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.operation.log;

import cn.bbwres.biscuit.operation.log.aspect.OperationLogAspect;
import cn.bbwres.biscuit.operation.log.properties.OperationLogProperties;
import cn.bbwres.biscuit.operation.log.service.EnhanceOperationLogService;
import cn.bbwres.biscuit.operation.log.service.OperationLogSaveService;
import cn.bbwres.biscuit.operation.log.service.impl.EnhanceOperationLogBaseServiceImpl;
import cn.bbwres.biscuit.operation.log.service.impl.EnhanceOperationLogParamsServiceImpl;
import cn.bbwres.biscuit.operation.log.service.impl.EnhanceOperationLogSpringElServiceImpl;
import cn.bbwres.biscuit.operation.log.service.impl.EnhanceOperationLogUserServiceImpl;
import cn.bbwres.biscuit.operation.log.service.impl.EnhanceOperationLogWebServiceImpl;
import cn.bbwres.biscuit.operation.log.service.impl.SaveOperationLogServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;

@AutoConfiguration
@EnableConfigurationProperties(value={OperationLogProperties.class})
public class OperationLogAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(OperationLogAutoConfigure.class);

    @Bean
    public OperationLogAspect operationLogAspect(List<EnhanceOperationLogService> enhanceOperationLogServices) {
        return new OperationLogAspect(enhanceOperationLogServices);
    }

    @Bean
    @Order(value=1)
    public EnhanceOperationLogService enhanceOperationLogBaseService(Environment environment) {
        return new EnhanceOperationLogBaseServiceImpl(environment);
    }

    @Bean
    @Order(value=100)
    public EnhanceOperationLogService enhanceOperationLogParamsService() {
        return new EnhanceOperationLogParamsServiceImpl();
    }

    @Bean(value={"enhanceOperationLogSpringElService"})
    @Order(value=300)
    public EnhanceOperationLogService enhanceOperationLogSpringElService() {
        return new EnhanceOperationLogSpringElServiceImpl((ExpressionParser)new SpelExpressionParser());
    }

    @Bean
    @Order(value=200)
    public EnhanceOperationLogService enhanceOperationLogUserService(OperationLogProperties operationLogProperties) {
        return new EnhanceOperationLogUserServiceImpl(operationLogProperties);
    }

    @ConditionalOnBean(value={OperationLogSaveService.class})
    protected static class SaveEnhanceOperationLogConfiguration {
        protected SaveEnhanceOperationLogConfiguration() {
        }

        @Bean
        @Order(value=999999)
        public EnhanceOperationLogService saveOperationLogService(OperationLogSaveService operationLogSaveService) {
            return new SaveOperationLogServiceImpl(operationLogSaveService);
        }
    }

    @ConditionalOnClass(value={DelegatingWebMvcConfiguration.class})
    protected static class WebEnhanceOperationLogConfiguration {
        protected WebEnhanceOperationLogConfiguration() {
        }

        @Bean
        @Order(value=500)
        public EnhanceOperationLogService enhanceOperationLogWebService() {
            return new EnhanceOperationLogWebServiceImpl();
        }
    }
}

