/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.operation.log.utils;

import cn.bbwres.biscuit.operation.log.aspect.OperationLogAspect;
import cn.bbwres.biscuit.operation.log.entity.OperationLogEntity;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLogUtils {
    private static final Logger OPERATION_LOG = LoggerFactory.getLogger((String)"OPERATION_LOG");

    public static void setContent(String content) {
        OperationLogAspect.setContent(content);
    }

    public static void addExt(String key, Object value) {
        OperationLogAspect.addExt(key, value);
    }

    public static void log(OperationLogEntity msg) {
        OPERATION_LOG.info("{}", (Object)msg);
    }

    public static void log(String system, String module, String business, String content, String operation, String requestMsg, String responseMsg, String businessId, String operationUser, String operationUserName, String exceptionMsg, String loggerLevel, boolean accessRequest) {
        OperationLogEntity msg = new OperationLogEntity().setSystem(system).setModule(module).setBusiness(business).setContent(content).setOperation(operation).setRequestMsg(requestMsg).setResponseMsg(responseMsg).setBusinessId(businessId).setOperationUser(operationUser).setOperationUserName(operationUserName).setExceptionMsg(exceptionMsg).setLoggerLevel(loggerLevel).setAccessRequest(accessRequest).setCreateTime(LocalDateTime.now().format(OperationLogAspect.DATE_TIME_FORMATTER));
        OperationLogUtils.log(msg);
    }
}

