/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.operation.log.service.impl;

import cn.bbwres.biscuit.operation.log.annotation.OperationLog;
import cn.bbwres.biscuit.operation.log.entity.OperationLogEntity;
import cn.bbwres.biscuit.operation.log.service.EnhanceOperationLogService;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class EnhanceOperationLogSpringElServiceImpl
implements EnhanceOperationLogService {
    private final ExpressionParser parser;

    @Override
    public void enhance(OperationLogEntity loggerMsg, OperationLog operateLog, ProceedingJoinPoint joinPoint, Object response, Throwable exception) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Parameter[] parameters = method.getParameters();
        if (StringUtils.isNotBlank((CharSequence)operateLog.businessId())) {
            loggerMsg.setBusinessId(this.springElParser(parameters, joinPoint.getArgs(), operateLog.businessId()));
        }
        if (StringUtils.isNotBlank((CharSequence)operateLog.content()) && StringUtils.isBlank((CharSequence)loggerMsg.getContent())) {
            loggerMsg.setContent(this.springElParser(parameters, joinPoint.getArgs(), operateLog.content()));
        }
    }

    protected String springElParser(Parameter[] parameters, Object[] args, String springEl) {
        Expression expression;
        Object result;
        if (!springEl.contains("$") && !springEl.contains("#")) {
            return springEl;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (ArrayUtils.isNotEmpty((Object[])parameters)) {
            for (int i = 0; i < parameters.length; ++i) {
                context.setVariable(parameters[i].getName(), args[i]);
            }
        }
        return Objects.nonNull(result = (expression = this.parser.parseExpression(springEl)).getValue((EvaluationContext)context)) ? result.toString() : null;
    }

    public EnhanceOperationLogSpringElServiceImpl(ExpressionParser parser) {
        this.parser = parser;
    }
}

