/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.mongodb.dao;

import cn.bbwres.biscuit.dto.Page;
import cn.bbwres.biscuit.dto.Sort;
import cn.bbwres.biscuit.dto.SortInfo;
import cn.bbwres.biscuit.mongodb.dao.ExtendMongoRepository;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.util.CollectionUtils;

public class ExtendSimpleMongoRepository<T, ID>
extends SimpleMongoRepository<T, ID>
implements ExtendMongoRepository<T, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public ExtendSimpleMongoRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.mongoOperations = mongoOperations;
        this.entityInformation = metadata;
    }

    @Override
    public Collection<T> insertAll(Collection<? extends T> objectsToSave) {
        return this.mongoOperations.insertAll(objectsToSave);
    }

    @Override
    public T findOne(Criteria query) {
        return (T)this.mongoOperations.findOne(Query.query((CriteriaDefinition)query), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public List<T> find(Query query) {
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public DeleteResult delete(Query query) {
        return this.mongoOperations.remove(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public UpdateResult update(Update update, Query query) {
        return this.mongoOperations.updateMulti(query, (UpdateDefinition)update, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public <Q> Page<T, Q> pageList(List<CriteriaDefinition> criteria, int pageSize, long current, List<SortInfo> sortInfos) {
        Query query = new Query();
        if (!CollectionUtils.isEmpty(criteria)) {
            for (CriteriaDefinition criteriaDefinition : criteria) {
                query.addCriteria(criteriaDefinition);
            }
        }
        org.springframework.data.domain.Sort sort = null;
        if (!CollectionUtils.isEmpty(sortInfos)) {
            ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>(16);
            for (SortInfo sortInfo : sortInfos) {
                if (Sort.DESC.equals((Object)sortInfo.getSort())) {
                    orderList.add(Sort.Order.desc((String)sortInfo.getSortField()));
                    continue;
                }
                orderList.add(Sort.Order.asc((String)sortInfo.getSortField()));
            }
            sort = org.springframework.data.domain.Sort.by(orderList);
        }
        Long total = this.count(Query.of((Query)query).limit(-1).skip(-1L));
        PageRequest pageRequest = PageRequest.of((int)((int)current - 1), (int)pageSize);
        query = query.with((Pageable)pageRequest).with(sort == null ? org.springframework.data.domain.Sort.unsorted() : sort);
        List list = this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        Page page = new Page();
        page.setRecords(list);
        page.setTotal(total.longValue());
        page.setCurrent(current);
        page.setSize((long)pageSize);
        page.calculationPages();
        return page;
    }

    @Override
    public Long count(Query query) {
        return this.mongoOperations.count(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }
}

