/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.mongodb.processor;

import cn.bbwres.biscuit.mongodb.config.MongodbParams;
import cn.bbwres.biscuit.mongodb.config.MongodbProperties;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.util.CollectionUtils;

public class MongodbBeanContextAware
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MongodbBeanContextAware.class);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        MongodbProperties properties = (MongodbProperties)applicationContext.getBean(MongodbProperties.class);
        Map<String, MongodbParams> config = properties.getConfig();
        if (CollectionUtils.isEmpty(config)) {
            log.info("\u5f53\u524d\u672a\u914d\u7f6e\u591a\u6570\u636e\u6e90\u7684mongodb\u53c2\u6570");
            return;
        }
        MappingMongoConverter converter = (MappingMongoConverter)applicationContext.getBean(MappingMongoConverter.class);
        for (String name : config.keySet()) {
            MongodbParams params = config.get(name);
            ConnectionString connectionString = new ConnectionString(params.getConnectionString());
            MongoClient mongoClient = MongoClients.create((ConnectionString)connectionString);
            DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
            defaultListableBeanFactory.registerSingleton(name + "MongoClient", (Object)mongoClient);
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoTemplate.class);
            beanDefinitionBuilder.addConstructorArgValue((Object)new SimpleMongoClientDatabaseFactory(mongoClient, connectionString.getDatabase()));
            beanDefinitionBuilder.addConstructorArgValue((Object)converter);
            defaultListableBeanFactory.registerBeanDefinition(name + "MongoTemplate", (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
    }
}

