/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.mongodb;

import cn.bbwres.biscuit.mongodb.config.MongodbProperties;
import cn.bbwres.biscuit.mongodb.dao.ExtendSimpleMongoRepository;
import cn.bbwres.biscuit.mongodb.processor.MongodbBeanContextAware;
import com.mongodb.client.MongoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConditionalOnClass(value={MongoClient.class})
@EnableConfigurationProperties(value={MongodbProperties.class})
@EnableTransactionManagement
@EnableMongoRepositories(basePackages={"${spring.data.mongodb.repositories.base-packages}"}, repositoryBaseClass=ExtendSimpleMongoRepository.class)
public class MongodbAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(MongodbAutoConfigure.class);

    @Bean
    public MongodbBeanContextAware mongodbBeanContextAware() {
        return new MongodbBeanContextAware();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.data.mongodb.remove", name={"class"}, havingValue="true", matchIfMissing=false)
    MappingMongoConverter mappingMongoConverter(MongoDatabaseFactory factory, MongoMappingContext context, MongoCustomConversions conversions) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        mappingConverter.setCustomConversions((CustomConversions)conversions);
        mappingConverter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return mappingConverter;
    }
}

