/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.i18n.support;

import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.ObjectUtils;

public class SupportMessageSource
implements MessageSource {
    private final List<MessageSource> messageSources;

    public SupportMessageSource(List<MessageSource> messageSources) {
        this.messageSources = messageSources;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageBySource(code, args, defaultMessage, locale);
    }

    protected String getMessageBySource(String code, Object[] args, String defaultMessage, Locale locale) {
        String message = null;
        for (MessageSource messageSource : this.messageSources) {
            message = messageSource.getMessage(code, args, locale);
            if (ObjectUtils.isEmpty((Object)message)) continue;
            return message;
        }
        return ObjectUtils.isEmpty(message) ? defaultMessage : message;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageBySource(code, args, null, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String message = null;
        String defaultMessage = resolvable.getDefaultMessage();
        for (MessageSource messageSource : this.messageSources) {
            message = messageSource.getMessage(resolvable, locale);
            if (ObjectUtils.isEmpty((Object)message)) continue;
            return message;
        }
        return ObjectUtils.isEmpty(message) ? defaultMessage : message;
    }
}

