/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.i18n;

import cn.bbwres.biscuit.i18n.I18nProperties;
import cn.bbwres.biscuit.i18n.support.SupportMessageSource;
import cn.bbwres.biscuit.i18n.support.SystemMessageSource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.MessageSourceAccessor;

@AutoConfiguration
@EnableConfigurationProperties(value={I18nProperties.class})
public class I18nAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(I18nAutoConfigure.class);

    @Bean(value={"systemMessageSource"})
    public SystemMessageSource systemMessageSource() {
        return new SystemMessageSource();
    }

    @Bean
    public SupportMessageSource messageSource(List<MessageSource> messageSources) {
        return new SupportMessageSource(messageSources);
    }

    @Bean
    public MessageSourceAccessor messageSourceAccessor(SupportMessageSource supportMessageSource) {
        return new MessageSourceAccessor((MessageSource)supportMessageSource);
    }
}

