/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.service;

import cn.bbwres.biscuit.dto.Result;
import cn.bbwres.biscuit.entity.UserBaseInfo;
import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.service.ResourceService;
import java.util.List;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class ResourceServiceImpl
implements ResourceService {
    private final WebClient webClient;
    private final GatewayProperties gatewayProperties;
    private final ParameterizedTypeReference<Result<List<String>>> STRING_TYPE_REFERENCE = new ParameterizedTypeReference<Result<List<String>>>(this){};
    private final ParameterizedTypeReference<Result<UserBaseInfo>> USER_BASE_INFO_TYPE_REFERENCE = new ParameterizedTypeReference<Result<UserBaseInfo>>(this){};

    public ResourceServiceImpl(WebClient webClient, GatewayProperties gatewayProperties) {
        this.webClient = webClient;
        this.gatewayProperties = gatewayProperties;
    }

    @Override
    public Mono<UserBaseInfo> checkToken(String token) {
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.gatewayProperties.getAuthorizationServerName() + this.gatewayProperties.getAuthorizationServerCheckTokenPath(), new Object[0])).bodyValue((Object)token).retrieve().bodyToMono(this.USER_BASE_INFO_TYPE_REFERENCE).map(Result::checkAndGetData);
    }

    @Override
    public Mono<List<String>> getLoginAuthResource() {
        return this.webClient.get().uri(this.gatewayProperties.getAuthorizationServerName() + this.gatewayProperties.getAuthorizationServerLoginAuthResource(), new Object[0]).retrieve().bodyToMono(this.STRING_TYPE_REFERENCE).map(Result::checkAndGetData);
    }

    @Override
    public Mono<List<String>> getResourceByRole(Set<String> roleIds) {
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.gatewayProperties.getAuthorizationServerName() + this.gatewayProperties.getAuthorizationServerResourceByRole(), new Object[0])).bodyValue(roleIds).retrieve().bodyToMono(this.STRING_TYPE_REFERENCE).map(Result::checkAndGetData);
    }
}

