/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.route;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.route.DefaultGatewayRoute;
import cn.bbwres.biscuit.nacos.operation.AbstractNacosProcessor;
import cn.bbwres.biscuit.nacos.operation.NacosConfigOperation;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

public class GatewayRouteNacosProcessor
extends AbstractNacosProcessor {
    private static final String APP_NAME = "spring.application.name";
    private static final String DYNAMIC_ROUTE = "-dynamic-route";
    private final DefaultGatewayRoute defaultGatewayRoute;
    private final GatewayProperties gatewayProperties;
    private final Environment environment;

    public GatewayRouteNacosProcessor(NacosConfigOperation nacosConfigOperation, DefaultGatewayRoute defaultGatewayRoute, GatewayProperties gatewayProperties, Environment environment) {
        super(nacosConfigOperation);
        this.defaultGatewayRoute = defaultGatewayRoute;
        this.gatewayProperties = gatewayProperties;
        this.environment = environment;
    }

    public String getGroup() {
        return this.gatewayProperties.getDynamicRouteGroup();
    }

    public String getDataId() {
        if (!ObjectUtils.isEmpty((Object)this.gatewayProperties.getDynamicRouteDataId())) {
            return this.gatewayProperties.getDynamicRouteDataId();
        }
        return this.environment.getProperty(APP_NAME) + DYNAMIC_ROUTE;
    }

    public void callbackConfig(String config) {
        this.defaultGatewayRoute.updateAll(config);
    }
}

