/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.route;

import cn.bbwres.biscuit.exception.SystemRuntimeException;
import cn.bbwres.biscuit.gateway.route.GatewayRoute;
import cn.bbwres.biscuit.gateway.route.entity.GatewayRouteInfoEntity;
import cn.bbwres.biscuit.utils.JsonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultGatewayRoute
implements GatewayRoute,
ApplicationEventPublisherAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGatewayRoute.class);
    public static final String EMPTY_JSON_RULE_MULTIPLE = "[]";
    private final RouteDefinitionLocator routeDefinitionLocator;
    private final RouteDefinitionWriter routeDefinitionWriter;
    private final GatewayProperties gatewayProperties;
    private ApplicationEventPublisher applicationEventPublisher;

    public DefaultGatewayRoute(RouteDefinitionLocator routeDefinitionLocator, RouteDefinitionWriter routeDefinitionWriter, GatewayProperties gatewayProperties) {
        this.routeDefinitionLocator = routeDefinitionLocator;
        this.routeDefinitionWriter = routeDefinitionWriter;
        this.gatewayProperties = gatewayProperties;
    }

    @Override
    public synchronized void add(GatewayRouteInfoEntity gatewayRouteInfoEntity) {
        String routeId;
        if (gatewayRouteInfoEntity == null) {
            throw new SystemRuntimeException("Gateway dynamic route is null");
        }
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        if (routeDefinitionMap.containsKey(routeId = gatewayRouteInfoEntity.getId())) {
            throw new SystemRuntimeException("Gateway dynamic route for routeId=[" + routeId + "] is duplicated");
        }
        RouteDefinition routeDefinition = this.convertRoute(gatewayRouteInfoEntity);
        this.addRoute(routeDefinition);
        log.info("Added Gateway dynamic route={}", (Object)routeDefinition);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    @Override
    public synchronized void modify(GatewayRouteInfoEntity gatewayRouteInfoEntity) {
        String routeId;
        if (gatewayRouteInfoEntity == null) {
            throw new SystemRuntimeException("Gateway dynamic route is null");
        }
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        if (!routeDefinitionMap.containsKey(routeId = gatewayRouteInfoEntity.getId())) {
            throw new SystemRuntimeException("Gateway dynamic route for routeId=[" + routeId + "] isn't found");
        }
        RouteDefinition routeDefinition = this.convertRoute(gatewayRouteInfoEntity);
        this.modifyRoute(routeDefinition);
        log.info("Modified Gateway dynamic route={}", (Object)routeDefinition);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    @Override
    public synchronized void delete(String routeId) {
        if (StringUtils.isEmpty((CharSequence)routeId)) {
            throw new SystemRuntimeException("RouteId is empty");
        }
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        RouteDefinition routeDefinition = routeDefinitionMap.get(routeId);
        if (routeDefinition == null) {
            throw new SystemRuntimeException("Gateway dynamic route for routeId=[" + routeId + "] isn't found");
        }
        this.deleteRoute(routeDefinition);
        log.info("Deleted Gateway dynamic route for routeId={}", (Object)routeId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    @Override
    public void updateAll(List<GatewayRouteInfoEntity> gatewayRouteEntityList) {
        RouteDefinition routeDefinition;
        String routeId;
        if (CollectionUtils.isEmpty(gatewayRouteEntityList)) {
            throw new SystemRuntimeException("Gateway dynamic routes are null");
        }
        boolean isIdDuplicated = this.isIdDuplicated(gatewayRouteEntityList);
        if (isIdDuplicated) {
            throw new SystemRuntimeException("Gateway dynamic routes have duplicated routeIds");
        }
        Map<String, RouteDefinition> dynamicRouteDefinitionMap = gatewayRouteEntityList.stream().collect(Collectors.toMap(GatewayRouteInfoEntity::getId, this::convertRoute));
        Map<String, RouteDefinition> currentRouteDefinitionMap = this.locateRoutes();
        ArrayList<RouteDefinition> addRouteDefinitionList = new ArrayList<RouteDefinition>(dynamicRouteDefinitionMap.size());
        ArrayList<RouteDefinition> modifyRouteDefinitionList = new ArrayList<RouteDefinition>(dynamicRouteDefinitionMap.size());
        ArrayList<RouteDefinition> deleteRouteDefinitionList = new ArrayList<RouteDefinition>(dynamicRouteDefinitionMap.size());
        for (Map.Entry<String, RouteDefinition> entry : dynamicRouteDefinitionMap.entrySet()) {
            routeId = entry.getKey();
            routeDefinition = entry.getValue();
            if (currentRouteDefinitionMap.containsKey(routeId)) continue;
            addRouteDefinitionList.add(routeDefinition);
        }
        for (Map.Entry<String, RouteDefinition> entry : dynamicRouteDefinitionMap.entrySet()) {
            RouteDefinition currentRouteDefinition;
            routeId = entry.getKey();
            routeDefinition = entry.getValue();
            if (!currentRouteDefinitionMap.containsKey(routeId) || (currentRouteDefinition = currentRouteDefinitionMap.get(routeId)).equals((Object)routeDefinition)) continue;
            modifyRouteDefinitionList.add(routeDefinition);
        }
        for (Map.Entry<String, RouteDefinition> entry : currentRouteDefinitionMap.entrySet()) {
            routeId = entry.getKey();
            routeDefinition = entry.getValue();
            if (dynamicRouteDefinitionMap.containsKey(routeId)) continue;
            deleteRouteDefinitionList.add(routeDefinition);
        }
        for (RouteDefinition routeDefinition2 : addRouteDefinitionList) {
            this.addRoute(routeDefinition2);
        }
        for (RouteDefinition routeDefinition2 : modifyRouteDefinitionList) {
            this.modifyRoute(routeDefinition2);
        }
        for (RouteDefinition routeDefinition2 : deleteRouteDefinitionList) {
            this.deleteRoute(routeDefinition2);
        }
        log.info("--- Gateway Dynamic Routes Update Information ----");
        log.info("Total count={}", (Object)gatewayRouteEntityList.size());
        log.info("Added count={}", (Object)addRouteDefinitionList.size());
        log.info("Modified count={}", (Object)modifyRouteDefinitionList.size());
        log.info("Deleted count={}", (Object)deleteRouteDefinitionList.size());
        log.info("--------------------------------------------------");
        if (addRouteDefinitionList.isEmpty() && modifyRouteDefinitionList.isEmpty() && deleteRouteDefinitionList.isEmpty()) {
            return;
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    @Override
    public void updateAll(String gatewayStrategyRouteConfig) {
        if (StringUtils.isBlank((CharSequence)gatewayStrategyRouteConfig)) {
            gatewayStrategyRouteConfig = EMPTY_JSON_RULE_MULTIPLE;
        }
        List gatewayStrategyRouteEntityList = (List)JsonUtil.toObject((String)gatewayStrategyRouteConfig, (TypeReference)new TypeReference<List<GatewayRouteInfoEntity>>(this){});
        this.updateAll(gatewayStrategyRouteEntityList);
    }

    public Map<String, RouteDefinition> locateRoutes() {
        Flux routeDefinitions = this.routeDefinitionLocator.getRouteDefinitions();
        try {
            List routeDefinitionList = (List)routeDefinitions.collectList().block();
            if (CollectionUtils.isEmpty((Collection)routeDefinitionList)) {
                return new HashMap<String, RouteDefinition>(2);
            }
            return routeDefinitionList.stream().collect(Collectors.toMap(RouteDefinition::getId, routeDefinition -> routeDefinition));
        }
        catch (Exception e) {
            return new HashMap<String, RouteDefinition>(2);
        }
    }

    private boolean isIdDuplicated(List<GatewayRouteInfoEntity> gatewayRouteInfoEntityList) {
        TreeSet<GatewayRouteInfoEntity> gatewayStrategyRouteEntitySet = new TreeSet<GatewayRouteInfoEntity>(Comparator.comparing(GatewayRouteInfoEntity::getId));
        gatewayStrategyRouteEntitySet.addAll(gatewayRouteInfoEntityList);
        return gatewayStrategyRouteEntitySet.size() < gatewayRouteInfoEntityList.size();
    }

    public RouteDefinition convertRoute(GatewayRouteInfoEntity gatewayRouteInfoEntity) {
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(gatewayRouteInfoEntity.getId());
        routeDefinition.setUri(this.convertURI(gatewayRouteInfoEntity.getUri()));
        List<String> predicateList = gatewayRouteInfoEntity.getPredicates();
        List<GatewayRouteInfoEntity.Predicate> userPredicates = gatewayRouteInfoEntity.getUserPredicates();
        ArrayList<PredicateDefinition> predicateDefinitionList = new ArrayList<PredicateDefinition>(predicateList.size() + userPredicates.size());
        for (String string : predicateList) {
            predicateDefinitionList.add(new PredicateDefinition(string));
        }
        for (GatewayRouteInfoEntity.Predicate predicate : userPredicates) {
            PredicateDefinition predicateDefinition = new PredicateDefinition();
            predicateDefinition.setName(predicate.getName());
            predicateDefinition.setArgs(predicate.getArgs());
            predicateDefinitionList.add(predicateDefinition);
        }
        routeDefinition.setPredicates(predicateDefinitionList);
        List<String> filterList = gatewayRouteInfoEntity.getFilters();
        List<GatewayRouteInfoEntity.Filter> list = gatewayRouteInfoEntity.getUserFilters();
        ArrayList<FilterDefinition> filterDefinitionList = new ArrayList<FilterDefinition>(filterList.size() + list.size());
        for (String string : filterList) {
            filterDefinitionList.add(new FilterDefinition(string));
        }
        for (GatewayRouteInfoEntity.Filter filter : list) {
            FilterDefinition filterDefinition = new FilterDefinition();
            filterDefinition.setName(filter.getName());
            filterDefinition.setArgs(filter.getArgs());
            filterDefinitionList.add(filterDefinition);
        }
        routeDefinition.setFilters(filterDefinitionList);
        routeDefinition.setOrder(gatewayRouteInfoEntity.getOrder());
        routeDefinition.setMetadata(gatewayRouteInfoEntity.getMetadata());
        return routeDefinition;
    }

    public GatewayRouteInfoEntity convertRoute(RouteDefinition routeDefinition) {
        GatewayRouteInfoEntity gatewayStrategyRouteEntity = new GatewayRouteInfoEntity();
        gatewayStrategyRouteEntity.setId(routeDefinition.getId());
        gatewayStrategyRouteEntity.setUri(routeDefinition.getUri().toString());
        gatewayStrategyRouteEntity.setOrder(routeDefinition.getOrder());
        try {
            gatewayStrategyRouteEntity.setMetadata(routeDefinition.getMetadata());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.convertPredicates(routeDefinition.getPredicates(), gatewayStrategyRouteEntity.getPredicates(), gatewayStrategyRouteEntity.getUserPredicates());
        this.convertFilters(routeDefinition.getFilters(), gatewayStrategyRouteEntity.getFilters(), gatewayStrategyRouteEntity.getUserFilters());
        return gatewayStrategyRouteEntity;
    }

    public void convertPredicates(List<PredicateDefinition> predicateDefinitionList, List<String> predicateList, List<GatewayRouteInfoEntity.Predicate> userPredicateList) {
        for (PredicateDefinition predicateDefinition : predicateDefinitionList) {
            String name = predicateDefinition.getName();
            Map args = predicateDefinition.getArgs();
            boolean internal = this.isInternal(args);
            if (internal) {
                predicateList.add(String.format("%s=%s", name, StringUtils.join(args.values(), (String)",")));
                continue;
            }
            GatewayRouteInfoEntity.Predicate predicate = new GatewayRouteInfoEntity.Predicate();
            predicate.setName(predicateDefinition.getName());
            predicate.setArgs(predicateDefinition.getArgs());
            userPredicateList.add(predicate);
        }
    }

    public void convertFilters(List<FilterDefinition> filterDefinitionList, List<String> filterList, List<GatewayRouteInfoEntity.Filter> userFilterList) {
        for (FilterDefinition filterDefinition : filterDefinitionList) {
            String name = filterDefinition.getName();
            Map args = filterDefinition.getArgs();
            boolean internal = this.isInternal(args);
            if (internal) {
                filterList.add(String.format("%s=%s", name, StringUtils.join(args.values(), (String)",")));
                continue;
            }
            GatewayRouteInfoEntity.Filter filter = new GatewayRouteInfoEntity.Filter();
            filter.setName(filterDefinition.getName());
            filter.setArgs(filterDefinition.getArgs());
            userFilterList.add(filter);
        }
    }

    public boolean isInternal(Map<String, String> args) {
        for (Map.Entry<String, String> entry : args.entrySet()) {
            String key = entry.getKey();
            if (!key.contains("_genkey_")) continue;
            return true;
        }
        return false;
    }

    public URI convertURI(String value) {
        URI uri = value.toLowerCase().startsWith("http") || value.toLowerCase().startsWith("https") ? UriComponentsBuilder.fromHttpUrl((String)value).build().toUri() : URI.create(value);
        return uri;
    }

    public void addRoute(RouteDefinition routeDefinition) {
        Disposable disposable = null;
        try {
            disposable = this.routeDefinitionWriter.save(Mono.just((Object)routeDefinition)).subscribe();
        }
        finally {
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }

    public void modifyRoute(RouteDefinition routeDefinition) {
        this.deleteRoute(routeDefinition);
        this.addRoute(routeDefinition);
    }

    public void deleteRoute(RouteDefinition routeDefinition) {
        Disposable disposable = null;
        try {
            disposable = this.routeDefinitionWriter.delete(Mono.just((Object)routeDefinition.getId())).onErrorResume(throwable -> {
                if (throwable instanceof NotFoundException) {
                    this.gatewayProperties.getRoutes().removeIf(routeCandidate -> routeCandidate.getId().equals(routeDefinition.getId()));
                    return Mono.empty();
                }
                return Mono.error((Throwable)throwable);
            }).subscribe();
        }
        finally {
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

