/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.filters.xss;

import cn.bbwres.biscuit.gateway.filters.xss.CachedBodyOutputMessage;
import cn.bbwres.biscuit.gateway.filters.xss.XssUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class XssUriRegexGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssUriRegexGatewayFilterFactory.class);
    private static final Set<HttpMethod> SUPPORT_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.POST, HttpMethod.GET, HttpMethod.PUT, HttpMethod.PATCH));
    public static final String REGEX_KEY = "regex";
    private final ServerCodecConfigurer serverCodecConfigurer;

    public XssUriRegexGatewayFilterFactory(ServerCodecConfigurer serverCodecConfigurer) {
        super(Config.class);
        this.serverCodecConfigurer = serverCodecConfigurer;
    }

    public List<String> shortcutFieldOrder() {
        return Collections.singletonList(REGEX_KEY);
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            ServerHttpRequest serverHttpRequest = exchange.getRequest();
            HttpMethod method = serverHttpRequest.getMethod();
            String contentType = serverHttpRequest.getHeaders().getFirst("Content-Type");
            if (!SUPPORT_METHODS.contains(method)) {
                return chain.filter(exchange);
            }
            String regex = config.getRegex();
            String uri = serverHttpRequest.getURI().getPath();
            if (!uri.matches(regex)) {
                return chain.filter(exchange);
            }
            if (StringUtils.isEmpty((CharSequence)contentType)) {
                return chain.filter(exchange);
            }
            String lowerContentType = contentType.toLowerCase();
            if (!("application/x-www-form-urlencoded".equalsIgnoreCase(contentType) || lowerContentType.contains("json") || lowerContentType.contains("text") || lowerContentType.contains("xml"))) {
                return chain.filter(exchange);
            }
            log.info("\u5f53\u524d\u8bf7\u6c42\u7684CONTENT_TYPE\u4e3a:{}", (Object)contentType);
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap(serverHttpRequest.getQueryParams().size());
            for (Map.Entry entry : serverHttpRequest.getQueryParams().entrySet()) {
                queryParams.addAll((Object)((String)entry.getKey()), ((List)entry.getValue()).stream().map(XssUtils::stripXss).collect(Collectors.toList()));
            }
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, (List)this.serverCodecConfigurer.getReaders());
            Mono rawBody = serverRequest.bodyToMono(String.class).map((Function)new Function<String, String>(this){

                @Override
                public String apply(String s) {
                    log.info("\u8f6c\u6362\u4e4b\u524d\u7684\u62a5\u6587\u4e3a:[{}]", (Object)s);
                    String msg = XssUtils.stripXss(s);
                    log.info("\u8f6c\u6362\u4e4b\u540e\u7684\u62a5\u6587\u4e3a:[{}]", (Object)msg);
                    return msg;
                }
            });
            BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)rawBody, String.class);
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers, (MultiValueMap<String, String>)queryParams);
            return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                ServerHttpRequestDecorator decorator = this.decorate(exchange, headers, outputMessage);
                return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
            }));
        };
    }

    ServerHttpRequestDecorator decorate(ServerWebExchange exchange, final HttpHeaders headers, final CachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(this, exchange.getRequest()){

            public HttpHeaders getHeaders() {
                long contentLength = headers.getContentLength();
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.putAll((Map)super.getHeaders());
                if (contentLength > 0L) {
                    httpHeaders.setContentLength(contentLength);
                } else {
                    httpHeaders.set("Transfer-Encoding", "chunked");
                }
                return httpHeaders;
            }

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }

            public MultiValueMap<String, String> getQueryParams() {
                return outputMessage.getQueryParams();
            }
        };
    }

    public static class Config {
        private String regex;

        @Generated
        public Config() {
        }

        @Generated
        public String getRegex() {
            return this.regex;
        }

        @Generated
        public void setRegex(String regex) {
            this.regex = regex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$regex = this.getRegex();
            String other$regex = other.getRegex();
            return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $regex = this.getRegex();
            result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "XssUriRegexGatewayFilterFactory.Config(regex=" + this.getRegex() + ")";
        }
    }
}

