/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.filters;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.filters.AuthFilter;
import cn.bbwres.biscuit.gateway.filters.LogFilter;
import cn.bbwres.biscuit.gateway.filters.xss.XssUriRegexGatewayFilterFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.codec.ServerCodecConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={GatewayProperties.class})
public class FiltersAutoConfigure {
    @Bean
    public AuthFilter authFilter(GatewayProperties gatewayProperties) {
        return new AuthFilter(gatewayProperties);
    }

    @Bean
    public LogFilter logFilter() {
        return new LogFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="biscuit.gateway", name={"use-xss-filter"}, havingValue="true")
    public XssUriRegexGatewayFilterFactory xssUriRegexGatewayFilterFactory(ServerCodecConfigurer serverCodecConfigurer) {
        return new XssUriRegexGatewayFilterFactory(serverCodecConfigurer);
    }
}

