/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.filters;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.utils.JsonUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AuthFilter
implements GlobalFilter,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    private final GatewayProperties gatewayProperties;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        log.debug("\u5904\u7406\u7528\u6237\u8ba4\u8bc1\u53c2\u6570\u4fe1\u606f");
        exchange = this.removeHeaders(exchange, this.gatewayProperties.getUserInfoHeader());
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpRequest.Builder builder = request.mutate();
        Object userInfo = exchange.getAttributes().get("USER_INFO");
        if (Objects.nonNull(userInfo)) {
            builder.header(this.gatewayProperties.getUserInfoHeader(), new String[]{JsonUtil.toJsonBase64(userInfo, (boolean)true)});
        }
        return chain.filter(exchange.mutate().request(builder.build()).build());
    }

    private ServerWebExchange removeHeaders(ServerWebExchange exchange, String ... headers) {
        if (ArrayUtils.isEmpty((Object[])headers)) {
            return exchange;
        }
        List<String> headerList = Arrays.stream(headers).filter(header -> exchange.getRequest().getHeaders().containsKey(header)).toList();
        ServerHttpRequest request = exchange.getRequest().mutate().headers(httpHeaders -> {
            for (String hh : headerList) {
                httpHeaders.remove((Object)hh);
            }
        }).build();
        return exchange.mutate().request(request).build();
    }

    public int getOrder() {
        return 9002;
    }

    @Generated
    public AuthFilter(GatewayProperties gatewayProperties) {
        this.gatewayProperties = gatewayProperties;
    }
}

