/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.cache;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.service.ResourceService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;

public class ResourceCacheService {
    public static final String LOGIN_AUTH_RESOURCE = "LOGIN_AUTH_RESOURCE";
    private Cache<String, Mono<List<String>>> resourceNoUserCache;
    private Cache<String, Mono<List<String>>> resourceRoleCache;
    private final GatewayProperties gatewayProperties;
    private final ResourceService resourceService;

    public ResourceCacheService(GatewayProperties gatewayProperties, ResourceService resourceService) {
        this.gatewayProperties = gatewayProperties;
        this.resourceService = resourceService;
    }

    @PostConstruct
    public void init() {
        if (this.gatewayProperties.getCacheResource().booleanValue()) {
            this.resourceNoUserCache = Caffeine.newBuilder().expireAfterWrite((long)this.gatewayProperties.getLocalCacheResourceTime().intValue(), TimeUnit.SECONDS).maximumSize(10L).build();
            this.resourceRoleCache = Caffeine.newBuilder().expireAfterWrite((long)this.gatewayProperties.getLocalCacheResourceTime().intValue(), TimeUnit.SECONDS).maximumSize(2000L).build();
        }
    }

    public Mono<List<String>> getLoginAuthResource() {
        if (this.gatewayProperties.getCacheResource().booleanValue()) {
            Mono loginAuthResourceMono = (Mono)this.resourceNoUserCache.getIfPresent((Object)LOGIN_AUTH_RESOURCE);
            if (loginAuthResourceMono != null) {
                return loginAuthResourceMono;
            }
            loginAuthResourceMono = this.resourceService.getLoginAuthResource().cache();
            this.resourceNoUserCache.put((Object)LOGIN_AUTH_RESOURCE, (Object)loginAuthResourceMono);
            return loginAuthResourceMono;
        }
        return this.resourceService.getLoginAuthResource();
    }

    public Mono<List<String>> getResourceByRole(Set<String> roleIds) {
        if (this.gatewayProperties.getCacheResource().booleanValue()) {
            String jsonKey = String.join((CharSequence)"-", roleIds);
            Mono resourceByRoleMono = (Mono)this.resourceRoleCache.getIfPresent((Object)jsonKey);
            if (resourceByRoleMono != null) {
                return resourceByRoleMono;
            }
            resourceByRoleMono = this.resourceService.getResourceByRole(roleIds).cache();
            this.resourceRoleCache.put((Object)jsonKey, (Object)resourceByRoleMono);
            return resourceByRoleMono;
        }
        return this.resourceService.getResourceByRole(roleIds);
    }

    public Mono<String> getLoginUrlBuildState(String state) {
        return this.resourceService.getLoginUrlBuildState(state);
    }
}

