/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.entity.UserBaseInfo;
import cn.bbwres.biscuit.exception.SystemRuntimeException;
import cn.bbwres.biscuit.exception.constants.GlobalErrorCodeConstants;
import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.authorization.MapAuthentication;
import cn.bbwres.biscuit.gateway.service.ResourceService;
import cn.bbwres.biscuit.gateway.service.ResourceServiceImpl;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@AutoConfiguration
public class TokenConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public ResourceService resourceService(WebClient webClient, GatewayProperties gatewayProperties) {
        return new ResourceServiceImpl(webClient, gatewayProperties);
    }

    @Bean
    public WebClient webClient(WebClient.Builder builder, ReactorLoadBalancerExchangeFilterFunction reactorLoadBalancerExchangeFilterFunction) {
        return builder.filter((ExchangeFilterFunction)reactorLoadBalancerExchangeFilterFunction).build();
    }

    @Bean
    public ReactiveAuthenticationManager reactiveAuthenticationManager(final ResourceService resourceService) {
        return new ReactiveAuthenticationManager(){

            public Mono<Authentication> authenticate(Authentication authentication) {
                return Mono.justOrEmpty((Object)authentication).filter(a -> a instanceof BearerTokenAuthenticationToken).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(this::makeRequest).flatMap(this::parseToken).cast(Authentication.class).onErrorMap(Exception.class, this::onError);
            }

            private Mono<UserBaseInfo> makeRequest(String token) {
                return resourceService.checkToken(token);
            }

            private Mono<MapAuthentication> parseToken(UserBaseInfo userBaseInfo) {
                return Mono.justOrEmpty((Object)new MapAuthentication(userBaseInfo));
            }

            private SystemRuntimeException onError(Exception ex) {
                log.info("\u5f53\u524dtoken\u8bf7\u6c42\u5904\u7406\u5931\u8d25!{}", (Object)ex.getMessage());
                if (ex instanceof SystemRuntimeException) {
                    SystemRuntimeException e = (SystemRuntimeException)ex;
                    throw e;
                }
                if (ex instanceof BadJwtException) {
                    return new SystemRuntimeException(GlobalErrorCodeConstants.INVALID_TOKEN);
                }
                return new SystemRuntimeException(ex.getMessage());
            }
        };
    }
}

