/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.dto.Result;
import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.authorization.AuthorizationManager;
import cn.bbwres.biscuit.gateway.cache.ResourceCacheService;
import cn.bbwres.biscuit.gateway.service.ResourceService;
import cn.bbwres.biscuit.utils.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.server.resource.web.server.authentication.ServerBearerTokenAuthenticationConverter;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import reactor.core.publisher.Mono;

@AutoConfiguration
@EnableWebFluxSecurity
@EnableConfigurationProperties(value={GatewayProperties.class})
public class ResourceServerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceServerConfig.class);

    @Bean
    public PathMatcher antPathMatcher() {
        return new AntPathMatcher();
    }

    @Bean
    public AuthorizationManager authorizationManager(ResourceCacheService resourceCacheService, PathMatcher pathMatcher) {
        return new AuthorizationManager(resourceCacheService, pathMatcher);
    }

    @Bean
    public ResourceCacheService resourceCacheService(GatewayProperties gatewayProperties, ResourceService resourceService) {
        return new ResourceCacheService(gatewayProperties, resourceService);
    }

    @Bean
    public ServerAuthenticationConverter serverAuthenticationConverter() {
        ServerBearerTokenAuthenticationConverter converter = new ServerBearerTokenAuthenticationConverter();
        converter.setAllowUriQueryParameter(true);
        return converter;
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new HttpMessageConverters((Collection)converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, GatewayProperties gatewayProperties, AuthorizationManager authorizationManager, ServerAccessDeniedHandler customServerAccessDeniedHandler, ServerAuthenticationEntryPoint customServerAuthenticationEntryPoint, ObjectProvider<ReactiveAuthenticationManager> reactiveAuthenticationManager) {
        http.oauth2ResourceServer(oauth2ResourceServer -> {
            ReactiveAuthenticationManager authenticationManager = (ReactiveAuthenticationManager)reactiveAuthenticationManager.getIfAvailable();
            Assert.notNull((Object)authenticationManager, (String)"\u4f7f\u7528jwtToken\u65f6\uff0c\u672a\u521d\u59cb\u5316ReactiveAuthenticationManager\u5904\u7406\u7c7b");
            oauth2ResourceServer.jwt(jwt -> jwt.authenticationManager(authenticationManager));
        });
        http.authorizeExchange(authorizeExchange -> {
            if (ArrayUtils.isNotEmpty((Object[])gatewayProperties.getNoAuthUris())) {
                ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(gatewayProperties.getNoAuthUris())).permitAll();
            }
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(HttpMethod.OPTIONS)).permitAll().anyExchange().access((ReactiveAuthorizationManager)authorizationManager);
        });
        http.exceptionHandling(exceptions -> exceptions.accessDeniedHandler(customServerAccessDeniedHandler).authenticationEntryPoint(customServerAuthenticationEntryPoint));
        if (gatewayProperties.getDisableCsrf().booleanValue()) {
            http.csrf(ServerHttpSecurity.CsrfSpec::disable);
        }
        if (gatewayProperties.getDisableCors().booleanValue()) {
            http.cors(ServerHttpSecurity.CorsSpec::disable);
        }
        return http.build();
    }

    @Bean
    public ServerAccessDeniedHandler customServerAccessDeniedHandler(GatewayProperties gatewayProperties) {
        return (serverWebExchange, e) -> {
            Result result = new Result(gatewayProperties.getAccessDeniedCode(), e.getMessage());
            return this.write(result, serverWebExchange.getResponse(), (Exception)e);
        };
    }

    @Bean
    public ServerAuthenticationEntryPoint customServerAuthenticationEntryPoint(GatewayProperties gatewayProperties) {
        return (serverWebExchange, e) -> {
            MultiValueMap stateMap = serverWebExchange.getRequest().getQueryParams();
            String state = "";
            if (!CollectionUtils.isEmpty((Map)stateMap)) {
                state = (String)stateMap.getFirst((Object)"state");
            }
            if (StringUtils.isBlank((CharSequence)state)) {
                state = serverWebExchange.getRequest().getHeaders().getFirst("state");
            }
            String url = gatewayProperties.getLoginStateUris().get(state);
            Result result = new Result(gatewayProperties.getAuthFailCode(), e.getMessage());
            result.setData((Object)url);
            return this.write(result, serverWebExchange.getResponse(), (Exception)e);
        };
    }

    private Mono<Void> write(Result<?> body, ServerHttpResponse response, Exception e) {
        log.info("\u5f53\u524d\u7528\u6237\u8bbf\u95ee\u5f53\u524d\u5730\u5740\u5931\u8d25!\u9519\u8bef\u4fe1\u606f\u4e3a:[{}]", (Object)e.getMessage());
        String resultStr = JsonUtil.toJson(body);
        if (ObjectUtils.isEmpty((Object)resultStr)) {
            resultStr = "error";
        }
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        response.getHeaders().set("Content-Type", "application/json");
        response.getHeaders().set("Cache-Control", "no-cache");
        DataBuffer buffer = response.bufferFactory().wrap(resultStr.getBytes(StandardCharsets.UTF_8));
        return response.writeWith((Publisher)Mono.just((Object)buffer));
    }

    @Generated
    public ResourceServerConfig() {
    }
}

